/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.state.empty;

import com.zzh.lib.views.def.HStateEmptyStrategy;

public abstract class CountEmptyStrategy
implements HStateEmptyStrategy {
    private final int mEmptyCount;

    public CountEmptyStrategy(int emptyCount) {
        if (emptyCount < 0) {
            throw new IllegalArgumentException("emptyCount must >= 0");
        }
        this.mEmptyCount = emptyCount;
    }

    @Override
    public boolean isDestroyed() {
        return false;
    }

    @Override
    public final HStateEmptyStrategy.Result getResult() {
        int count = this.getCount();
        if (count < 0) {
            return HStateEmptyStrategy.Result.None;
        }
        if (count <= this.mEmptyCount) {
            return HStateEmptyStrategy.Result.Empty;
        }
        return HStateEmptyStrategy.Result.Content;
    }

    protected abstract int getCount();
}

