/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.sticky.caching;

import android.util.LongSparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.RecyclerView;
import com.zzh.lib.views.sticky.HStickyRecyclerHeadersAdapter;
import com.zzh.lib.views.sticky.caching.HeaderProvider;
import com.zzh.lib.views.sticky.util.OrientationProvider;

public class HeaderViewCache
implements HeaderProvider {
    private final HStickyRecyclerHeadersAdapter mAdapter;
    private final LongSparseArray<View> mHeaderViews = new LongSparseArray();
    private final OrientationProvider mOrientationProvider;

    public HeaderViewCache(HStickyRecyclerHeadersAdapter adapter, OrientationProvider orientationProvider) {
        this.mAdapter = adapter;
        this.mOrientationProvider = orientationProvider;
    }

    @Override
    public View getHeader(RecyclerView parent, int position) {
        long headerId = this.mAdapter.getHeaderId(position);
        View header = (View)this.mHeaderViews.get(headerId);
        if (header == null) {
            int heightSpec;
            int widthSpec;
            Object viewHolder = this.mAdapter.onCreateHeaderViewHolder((ViewGroup)parent);
            this.mAdapter.onBindHeaderViewHolder(viewHolder, position);
            header = ((RecyclerView.ViewHolder)viewHolder).itemView;
            if (header.getLayoutParams() == null) {
                header.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
            }
            if (this.mOrientationProvider.getOrientation(parent) == 1) {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0x40000000);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0);
            } else {
                widthSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getWidth(), (int)0);
                heightSpec = View.MeasureSpec.makeMeasureSpec((int)parent.getHeight(), (int)0x40000000);
            }
            int childWidth = ViewGroup.getChildMeasureSpec((int)widthSpec, (int)(parent.getPaddingLeft() + parent.getPaddingRight()), (int)header.getLayoutParams().width);
            int childHeight = ViewGroup.getChildMeasureSpec((int)heightSpec, (int)(parent.getPaddingTop() + parent.getPaddingBottom()), (int)header.getLayoutParams().height);
            header.measure(childWidth, childHeight);
            header.layout(0, 0, header.getMeasuredWidth(), header.getMeasuredHeight());
            this.mHeaderViews.put(headerId, (Object)header);
        }
        return header;
    }

    @Override
    public void invalidate() {
        this.mHeaderViews.clear();
    }
}

