/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.transform;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.viewpager2.widget.ViewPager2;
import com.zzh.lib.views.utils.BannerUtils;

public class OverlapPageTransformer
implements ViewPager2.PageTransformer {
    private final int orientation;
    private final float minScale;
    private final float unSelectedItemRotation;
    private final float unSelectedItemAlpha;
    private final float itemGap;
    private final float scalingValue = 0.2f;

    public OverlapPageTransformer(int orientation, float minScale, float unSelectedItemRotation, float unSelectedItemAlpha, float itemGap) {
        this.orientation = orientation;
        this.minScale = minScale;
        this.unSelectedItemRotation = unSelectedItemRotation;
        this.unSelectedItemAlpha = unSelectedItemAlpha;
        this.itemGap = itemGap;
        if (minScale < 0.0f || (double)minScale > 1.0) {
            throw new IllegalArgumentException("minScale \u53d6\u503c\u8303\u56f4 1.0 to 0.0");
        }
        if (unSelectedItemAlpha < 0.0f || (double)unSelectedItemAlpha > 1.0) {
            throw new IllegalArgumentException("unSelectedItemAlpha \u53d6\u503c\u8303\u56f4 1.0 to 0.0");
        }
    }

    public void transformPage(@NonNull View page, float position) {
        page.setElevation(-Math.abs(position));
        float delta = Math.max(1.0f - Math.abs(position * 0.5f), 0.5f);
        if (this.unSelectedItemRotation != 0.0f) {
            float unSelectedItemRotationTmp = position > 0.0f ? this.unSelectedItemRotation : -this.unSelectedItemRotation;
            float rotation = unSelectedItemRotationTmp * (1.0f - delta);
            page.setRotationY(rotation);
        }
        float scaleDelta = Math.abs(position * 0.2f);
        float scale = Math.max(1.0f - scaleDelta, this.minScale);
        page.setScaleX(scale);
        page.setScaleY(scale);
        float dp2px = BannerUtils.dp2pxFloat(this.itemGap / 2.0f);
        if (0 == this.orientation) {
            float tx = position * dp2px + (position > 0.0f ? (float)(-page.getWidth()) * (1.0f - scale) : (float)page.getWidth() * (1.0f - scale));
            page.setTranslationX(tx);
        } else if (1 == this.orientation) {
            float ty = position * dp2px + (position > 0.0f ? (float)(-page.getWidth()) * (1.0f - scale) : (float)page.getWidth() * (1.0f - scale));
            page.setTranslationY(ty);
        } else {
            throw new IllegalArgumentException("orientation\u53c2\u6570\u9519\u8bef\uff0c\u53d6\u503cViewPager2.ORIENTATION_HORIZONTAL \u6216\u8005 ViewPager2.ORIENTATION_VERTICAL ");
        }
        if (this.unSelectedItemAlpha != 1.0f) {
            if (position >= -1.0f && position <= 1.0f) {
                page.setAlpha(0.5f + (1.0f - Math.abs(position)) * 0.5f);
            } else {
                page.setAlpha(0.5f / Math.abs(position * position));
            }
        }
    }
}

