/*
 * Decompiled with CFR 0.152.
 */
package com.zzh.lib.views.vp.manager;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.PagerSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.zzh.lib.views.def.OnViewPagerListener;

public class VerticalLayoutManager
extends LinearLayoutManager {
    private static final String TAG = "ViewPagerLayoutManager";
    private PagerSnapHelper mPagerSnapHelper;
    private OnViewPagerListener mOnViewPagerListener;
    private RecyclerView mRecyclerView;
    private int mDrift;
    private final RecyclerView.OnChildAttachStateChangeListener mChildAttachStateChangeListener = new RecyclerView.OnChildAttachStateChangeListener(){

        public void onChildViewAttachedToWindow(View view) {
            if (VerticalLayoutManager.this.mOnViewPagerListener != null && VerticalLayoutManager.this.getChildCount() == 1) {
                VerticalLayoutManager.this.mOnViewPagerListener.onInitComplete();
            }
        }

        public void onChildViewDetachedFromWindow(View view) {
            if (VerticalLayoutManager.this.mDrift >= 0) {
                if (VerticalLayoutManager.this.mOnViewPagerListener != null) {
                    VerticalLayoutManager.this.mOnViewPagerListener.onPageRelease(true, VerticalLayoutManager.this.getPosition(view));
                }
            } else if (VerticalLayoutManager.this.mOnViewPagerListener != null) {
                VerticalLayoutManager.this.mOnViewPagerListener.onPageRelease(false, VerticalLayoutManager.this.getPosition(view));
            }
        }
    };

    public VerticalLayoutManager(Context context) {
        super(context);
        this.init();
    }

    public VerticalLayoutManager(Context context, int orientation, boolean reverseLayout) {
        super(context, orientation, reverseLayout);
        this.init();
    }

    public VerticalLayoutManager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.mPagerSnapHelper = new PagerSnapHelper();
    }

    public void onAttachedToWindow(RecyclerView view) {
        super.onAttachedToWindow(view);
        this.mPagerSnapHelper.attachToRecyclerView(view);
        this.mRecyclerView = view;
        this.mRecyclerView.addOnChildAttachStateChangeListener(this.mChildAttachStateChangeListener);
    }

    public void onLayoutChildren(RecyclerView.Recycler recycler, RecyclerView.State state) {
        super.onLayoutChildren(recycler, state);
    }

    public void onScrollStateChanged(int state) {
        switch (state) {
            case 0: {
                View viewIdle = this.mPagerSnapHelper.findSnapView((RecyclerView.LayoutManager)this);
                if (viewIdle == null) break;
                int positionIdle = this.getPosition(viewIdle);
                if (this.mOnViewPagerListener == null || this.getChildCount() != 1) break;
                this.mOnViewPagerListener.onPageSelected(positionIdle, positionIdle == this.getItemCount() - 1);
            }
        }
    }

    public int scrollVerticallyBy(int dy, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.mDrift = dy;
        return super.scrollVerticallyBy(dy, recycler, state);
    }

    public int scrollHorizontallyBy(int dx, RecyclerView.Recycler recycler, RecyclerView.State state) {
        this.mDrift = dx;
        return super.scrollHorizontallyBy(dx, recycler, state);
    }

    public void setOnViewPagerListener(OnViewPagerListener listener) {
        this.mOnViewPagerListener = listener;
    }
}

