/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.IdentityKeyFunction;
import com.github.andrewoma.dexx.collection.SortedSet;
import com.github.andrewoma.dexx.collection.internal.base.AbstractSortedSet;
import com.github.andrewoma.dexx.collection.internal.builder.AbstractSelfBuilder;
import com.github.andrewoma.dexx.collection.internal.redblack.DerivedKeyFactory;
import com.github.andrewoma.dexx.collection.internal.redblack.RedBlackTree;
import com.github.andrewoma.dexx.collection.internal.redblack.Tree;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TreeSet<E>
extends AbstractSortedSet<E> {
    private final Tree<E, E> tree;
    private final RedBlackTree<E, E> redBlackTree;
    protected static final TreeSet EMPTY = new TreeSet();

    @NotNull
    public static <E> BuilderFactory<E, TreeSet<E>> factory(final Comparator<? super E> ordering) {
        return new BuilderFactory<E, TreeSet<E>>(){

            @Override
            @NotNull
            public Builder<E, TreeSet<E>> newBuilder() {
                return new AbstractSelfBuilder<E, TreeSet<E>>(new TreeSet(ordering)){

                    @Override
                    @NotNull
                    public Builder<E, TreeSet<E>> add(E element) {
                        this.result = ((TreeSet)this.result).add(element);
                        return this;
                    }
                };
            }
        };
    }

    public TreeSet() {
        this(null);
    }

    @NotNull
    public static <E> TreeSet<E> empty() {
        return EMPTY;
    }

    public TreeSet(Comparator<? super E> ordering) {
        this.tree = null;
        this.redBlackTree = new RedBlackTree(new DerivedKeyFactory(), ordering, new IdentityKeyFunction());
    }

    private TreeSet(Tree<E, E> tree, RedBlackTree<E, E> redBlackTree) {
        this.tree = tree;
        this.redBlackTree = redBlackTree;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.redBlackTree.getOrdering();
    }

    @Override
    @NotNull
    public TreeSet<E> add(E value) {
        return new TreeSet<E>(this.redBlackTree.update(this.tree, value, value, true), this.redBlackTree);
    }

    @Override
    @NotNull
    public TreeSet<E> remove(E value) {
        return new TreeSet<E>(this.redBlackTree.delete(this.tree, value), this.redBlackTree);
    }

    @Override
    public boolean contains(E value) {
        return this.redBlackTree.contains(this.tree, value);
    }

    @Override
    public int size() {
        return RedBlackTree.count(this.tree);
    }

    @Override
    @Nullable
    public E first() {
        try {
            return this.redBlackTree.smallest(this.tree).getValue();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    @Nullable
    public E last() {
        try {
            return this.redBlackTree.greatest(this.tree).getValue();
        }
        catch (NoSuchElementException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        return this.redBlackTree.keysIterator(this.tree);
    }

    @Override
    @NotNull
    public SortedSet<E> drop(int number) {
        return new TreeSet<E>(this.redBlackTree.drop(this.tree, number), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedSet<E> take(int number) {
        return new TreeSet<E>(this.redBlackTree.take(this.tree, number), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedSet<E> from(@NotNull E value, boolean inclusive) {
        return new TreeSet<E>(this.redBlackTree.from(this.tree, value, inclusive), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedSet<E> to(@NotNull E value, boolean inclusive) {
        return new TreeSet<E>(this.redBlackTree.until(this.tree, value, inclusive), this.redBlackTree);
    }

    @Override
    @NotNull
    public SortedSet<E> range(@NotNull E from, boolean fromInclusive, @NotNull E to, boolean toInclusive) {
        return new TreeSet<E>(this.redBlackTree.range(this.tree, from, fromInclusive, to, toInclusive), this.redBlackTree);
    }
}

