/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.regex.Pattern;
import org.n3r.eql.EqlPage;
import org.n3r.eql.ex.EqlException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.S;

public class DbDialect {
    private final String jdbcUrl;
    private String driverName;
    private String databaseId;
    static Pattern orderByPattern = Pattern.compile("\\border\\s+by\\b");

    public static DbDialect parseDbType(Connection connection) {
        try {
            DatabaseMetaData metaData = connection.getMetaData();
            String driverName = metaData.getDriverName();
            String jdbcUrl = metaData.getURL();
            return new DbDialect(driverName, jdbcUrl);
        }
        catch (SQLException ex) {
            throw new EqlException(ex);
        }
    }

    public static DbDialect parseDbType(String driverName, String jdbcUrl) {
        return new DbDialect(driverName, jdbcUrl);
    }

    public DbDialect(String driverName, String jdbcUrl) {
        this.driverName = driverName;
        this.jdbcUrl = jdbcUrl;
        this.databaseId = this.tryParseDatabaseId();
    }

    public String getDatabaseId() {
        return this.databaseId;
    }

    public EqlRun createPageSql(EqlRun eqlRun, EqlPage page) {
        if ("oracle".equals(this.databaseId)) {
            return this.createOraclePageSql(eqlRun, page);
        }
        if ("mysql".equals(this.databaseId)) {
            return this.createMySqlPageSql(eqlRun, page);
        }
        if ("h2".equals(this.databaseId)) {
            return this.createH2PageSql(eqlRun, page);
        }
        return eqlRun;
    }

    private String tryParseDatabaseId() {
        String dirverOrUrl = this.driverName;
        if (dirverOrUrl == null) {
            dirverOrUrl = this.jdbcUrl;
        }
        if (S.containsIgnoreCase(dirverOrUrl, "oracle")) {
            return "oracle";
        }
        if (S.containsIgnoreCase(dirverOrUrl, "mysql")) {
            return "mysql";
        }
        if (S.containsIgnoreCase(dirverOrUrl, "h2")) {
            return "h2";
        }
        if (S.containsIgnoreCase(dirverOrUrl, "db2")) {
            return "db2";
        }
        return this.driverName;
    }

    private EqlRun createMySqlPageSql(EqlRun eqlRun, EqlPage page) {
        EqlRun eqlRun1 = eqlRun.clone();
        eqlRun1.setRunSql(eqlRun.getRunSql() + " LIMIT ?,?");
        eqlRun1.setExtraBindParams(page.getStartIndex(), page.getPageRows());
        return eqlRun1;
    }

    private EqlRun createOraclePageSql(EqlRun eqlRun0, EqlPage eqlPage) {
        EqlRun eqlRun = eqlRun0.clone();
        eqlRun.setRunSql(this.createOraclePageSql(eqlRun.getRunSql()));
        int endIndex = eqlPage.getStartIndex() + eqlPage.getPageRows();
        eqlRun.setExtraBindParams(endIndex, eqlPage.getStartIndex());
        return eqlRun;
    }

    private String createOraclePageSql(String sql) {
        return "SELECT * FROM ( SELECT ROW__.*, ROWNUM RN__ FROM ( " + sql + " ) ROW__  WHERE ROWNUM <= ?) WHERE RN__ > ?";
    }

    private EqlRun createH2PageSql(EqlRun eqlRun0, EqlPage eqlPage) {
        EqlRun eqlRun = eqlRun0.clone();
        eqlRun.setRunSql(this.createH2PageSql(eqlRun.getRunSql()));
        int endIndex = eqlPage.getStartIndex() + eqlPage.getPageRows();
        eqlRun.setExtraBindParams(endIndex, eqlPage.getStartIndex());
        return eqlRun;
    }

    private String createH2PageSql(String sql) {
        return "SELECT * FROM ( SELECT *, ROWNUM() RN__ FROM (" + sql + " ) ROW__  WHERE ROWNUM() <= ?) WHERE RN__ > ?";
    }

    public EqlRun createTotalSql(EqlRun currRun) {
        EqlRun totalEqlRun = currRun.clone();
        totalEqlRun.setRunSql(this.createTotalSql(totalEqlRun.getRunSql()));
        totalEqlRun.setWillReturnOnlyOneRow(true);
        return totalEqlRun;
    }

    private String createTotalSql(String runSql) {
        int paramBoundPos;
        String sql = runSql.toUpperCase();
        boolean oneFromWoDistinctOrGroupby = false;
        int fromPos = sql.indexOf("FROM");
        if (sql.indexOf("DISTINCT") < 0 && fromPos >= 0 && sql.indexOf("FROM", fromPos + 4) < 0 && sql.indexOf("GROUP") < 0 && !orderByPattern.matcher(sql).find()) {
            oneFromWoDistinctOrGroupby = true;
        }
        if (fromPos < 0) {
            fromPos = 0;
        }
        if (oneFromWoDistinctOrGroupby && (paramBoundPos = sql.indexOf(63)) >= 0 && paramBoundPos < fromPos) {
            oneFromWoDistinctOrGroupby = false;
        }
        return oneFromWoDistinctOrGroupby ? "SELECT COUNT(*) AS CNT " + runSql.substring(fromPos) : "SELECT COUNT(*) CNT__ FROM (" + runSql + ") TOTAL";
    }
}

