/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.n3r.eql.DbDialect;
import org.n3r.eql.ESelectStmt;
import org.n3r.eql.EStmt;
import org.n3r.eql.EUpdateStmt;
import org.n3r.eql.EqlPage;
import org.n3r.eql.EqlTran;
import org.n3r.eql.Eqll;
import org.n3r.eql.codedesc.CodeDescs;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.config.EqlConfigCache;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.config.EqlConfigManager;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.impl.DefaultEqlConfigDecorator;
import org.n3r.eql.impl.EqlBatch;
import org.n3r.eql.impl.EqlProc;
import org.n3r.eql.impl.EqlRsRetriever;
import org.n3r.eql.impl.IterateOptions;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.map.EqlType;
import org.n3r.eql.param.EqlParamsBinder;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.trans.spring.EqlTransactionManager;
import org.n3r.eql.util.C;
import org.n3r.eql.util.Closes;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.Fucks;
import org.n3r.eql.util.Logs;
import org.n3r.eql.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Eql {
    public static final String DEFAULT_CONN_NAME = "DEFAULT";
    public static final int STACKTRACE_DEEP_FOUR = 4;
    public static final int STACKTRACE_DEEP_FIVE = 5;
    protected static Logger logger = LoggerFactory.getLogger(Eql.class);
    protected EqlConfigDecorator eqlConfig;
    protected EqlBlock eqlBlock;
    protected Object[] params;
    private String sqlClassPath;
    private EqlPage page;
    protected EqlBatch batch;
    protected Object[] dynamics;
    private EqlTran externalTran;
    private EqlTran internalTran;
    private DbDialect dbDialect;
    protected EqlRsRetriever rsRetriever = new EqlRsRetriever();
    private int fetchSize;
    protected List<EqlRun> eqlRuns;
    protected EqlRun currRun;
    protected Map<String, Object> execContext;
    private String defaultSqlId;
    private boolean cached = true;
    private String tagSqlId;
    private String sqlId;

    public Eql() {
        this(5);
    }

    public Eql(int stackDeep) {
        EqlConfig localConfig = Eqll.eqlConfigLocal.get();
        if (localConfig == null) {
            this.init(EqlConfigCache.getEqlConfig(DEFAULT_CONN_NAME), stackDeep);
        } else {
            this.init(localConfig, stackDeep);
        }
    }

    public Eql(String connectionName) {
        this.init(EqlConfigCache.getEqlConfig(connectionName), 4);
    }

    public Eql(EqlConfig eqlConfig) {
        this.init(eqlConfig, 4);
    }

    public Eql(EqlConfig eqlConfig, int stackDeep) {
        this.init(eqlConfig, stackDeep);
    }

    public Eql me() {
        return this;
    }

    public Eql tagSqlId(String tagSqlId) {
        this.tagSqlId = tagSqlId;
        return this;
    }

    private void init(EqlConfig eqlConfig, int stackDeep) {
        this.eqlConfig = eqlConfig instanceof EqlConfigDecorator ? (EqlConfigDecorator)eqlConfig : new DefaultEqlConfigDecorator(eqlConfig);
        this.prepareDefaultSqlId(stackDeep);
    }

    private void prepareDefaultSqlId(int stackDeep) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        StackTraceElement e = stackTrace[stackDeep];
        this.defaultSqlId = e.getMethodName();
    }

    public Connection getConnection() {
        return Eql.newTran(this.eqlConfig).getConn(this.eqlConfig, this.currRun);
    }

    private void createDbDialect() {
        EqlTran eqlTran = this.internalTran != null ? this.internalTran : this.externalTran;
        this.dbDialect = DbDialect.parseDbType(eqlTran.getDriverName(), eqlTran.getJdbcUrl());
        this.execContext.put("_databaseId", this.dbDialect.getDatabaseId());
    }

    protected void createConn() {
        (this.internalTran != null ? this.internalTran : this.externalTran).getConn(this.eqlConfig, this.currRun);
    }

    public Eql addContext(String key, Object value) {
        this.execContext.put(key, value);
        return this;
    }

    public List<EqlRun> evaluate(String ... directSqls) {
        this.checkPreconditions(directSqls);
        this.execContext = EqlUtils.newExecContext(this.params, this.dynamics);
        if (directSqls.length > 0) {
            this.eqlBlock = new EqlBlock();
        }
        this.eqlRuns = this.eqlBlock.createEqlRuns(this.tagSqlId, this.eqlConfig, this.execContext, this.params, this.dynamics, directSqls);
        IterateOptions.checkIterateOption(this.eqlBlock, this.eqlRuns, this.params);
        Iterator<EqlRun> i$ = this.eqlRuns.iterator();
        while (i$.hasNext()) {
            EqlRun eqlRun;
            this.currRun = eqlRun = i$.next();
            this.currRun.setForEvaluate(true);
            if (S.isBlank(this.currRun.getRunSql())) continue;
            new EqlParamsBinder().prepareBindParams(this.eqlBlock.hasIterateOption(), this.currRun);
            this.currRun.bindParamsForEvaluation(this.sqlClassPath);
        }
        return this.eqlRuns;
    }

    public <T> T execute(String ... directSqls) {
        this.checkPreconditions(directSqls);
        Object o = this.tryGetCache(directSqls);
        if (o != null) {
            return (T)o;
        }
        this.execContext = EqlUtils.newExecContext(this.params, this.dynamics);
        Object ret = null;
        boolean isAllSelect = false;
        try {
            this.tranStart();
            this.createDbDialect();
            if (directSqls.length > 0) {
                this.eqlBlock = new EqlBlock();
            }
            this.eqlRuns = this.eqlBlock.createEqlRuns(this.tagSqlId, this.eqlConfig, this.execContext, this.params, this.dynamics, directSqls);
            IterateOptions.checkIterateOption(this.eqlBlock, this.eqlRuns, this.params);
            isAllSelect = this.checkAllSelect(this.eqlRuns);
            this.prepareBatch();
            Iterator<EqlRun> i$ = this.eqlRuns.iterator();
            while (i$.hasNext()) {
                EqlRun eqlRun;
                this.currRun = eqlRun = i$.next();
                if (S.isBlank(this.currRun.getRunSql())) continue;
                this.checkBatchCmdsSupporting(eqlRun);
                new EqlParamsBinder().prepareBindParams(this.eqlBlock.hasIterateOption(), this.currRun);
                this.createConn();
                ret = this.runEql();
                this.currRun.setConnection(null);
                this.updateLastResultToExecutionContext(ret);
                this.currRun.setResult(ret);
                this.trySetCache(directSqls);
            }
            if (!isAllSelect) {
                this.tranCommit();
            }
        }
        catch (Throwable e) {
            if (!isAllSelect) {
                this.tranRollback();
            }
            logger.error("exec sql {} exception", (Object)(this.currRun == null ? "none" : this.currRun.getPrintSql()), (Object)e);
            throw Fucks.fuck(e);
        }
        finally {
            this.resetState();
            this.close();
        }
        return (T)ret;
    }

    private boolean checkAllSelect(List<EqlRun> eqlRuns) {
        for (EqlRun eqlRun : eqlRuns) {
            if (eqlRun.getSqlType().isSelect()) continue;
            return false;
        }
        return true;
    }

    private void prepareBatch() {
        if (this.batch == null) {
            return;
        }
        this.batch.prepare(this.sqlClassPath, this.eqlConfig, this.getSqlId(), this.tagSqlId);
    }

    private void trySetCache(String[] directSqls) {
        if (!this.isCacheUsable(directSqls)) {
            return;
        }
        this.eqlBlock.cacheResult(this.currRun, this.page);
    }

    private Object tryGetCache(String[] directSqls) {
        if (!this.isCacheUsable(directSqls)) {
            return null;
        }
        Optional<Object> cachedResult = this.eqlBlock.getCachedResult(this.params, this.dynamics, this.page);
        if (cachedResult == null) {
            return null;
        }
        return cachedResult.orNull();
    }

    private boolean isCacheUsable(String[] directSqls) {
        return directSqls.length == 0 && this.cached;
    }

    private void checkBatchCmdsSupporting(EqlRun currRun) {
        if (this.batch == null) {
            return;
        }
        switch (currRun.getSqlType()) {
            case INSERT: 
            case UPDATE: 
            case MERGE: 
            case DELETE: 
            case REPLACE: {
                break;
            }
            default: {
                throw new EqlExecuteException(currRun.getPrintSql() + " is not supported in batch mode");
            }
        }
    }

    protected void updateLastResultToExecutionContext(Object ret) {
        Object lastResult = ret;
        if (ret instanceof List) {
            List list = (List)ret;
            if (list.size() == 0) {
                lastResult = null;
            } else if (list.size() == 1) {
                lastResult = list.get(0);
            }
        }
        this.execContext.put("_lastResult", lastResult);
    }

    public List<EqlRun> getEqlRuns() {
        return this.eqlRuns;
    }

    protected void resetState() {
        this.rsRetriever.resetMaxRows();
    }

    public void close() {
        this.tranClose();
    }

    public ESelectStmt selectStmt() {
        this.checkPreconditions(new String[0]);
        this.execContext = EqlUtils.newExecContext(this.params, this.dynamics);
        this.tranStart();
        List<EqlRun> sqlSubs = this.eqlBlock.createEqlRunsByEqls(this.tagSqlId, this.eqlConfig, this.execContext, this.params, this.dynamics);
        if (sqlSubs.size() != 1) {
            throw new EqlExecuteException("only one select sql supported");
        }
        this.currRun = sqlSubs.get(0);
        if (!this.currRun.getSqlType().isSelect()) {
            throw new EqlExecuteException("only one select sql supported");
        }
        ESelectStmt selectStmt = new ESelectStmt();
        this.prepareStmt(selectStmt);
        selectStmt.setRsRetriever(this.rsRetriever);
        selectStmt.setFetchSize(this.fetchSize);
        return selectStmt;
    }

    public EUpdateStmt updateStmt() {
        this.checkPreconditions(new String[0]);
        this.execContext = EqlUtils.newExecContext(this.params, this.dynamics);
        this.tranStart();
        this.createConn();
        List<EqlRun> sqlSubs = this.eqlBlock.createEqlRunsByEqls(this.tagSqlId, this.eqlConfig, this.execContext, this.params, this.dynamics);
        if (sqlSubs.size() != 1) {
            throw new EqlExecuteException("only one update sql supported in this method");
        }
        this.currRun = sqlSubs.get(0);
        if (!this.currRun.getSqlType().isUpdateStmt()) {
            throw new EqlExecuteException("only one update/merge/delete/insert sql supported in this method");
        }
        EUpdateStmt updateStmt = new EUpdateStmt();
        this.prepareStmt(updateStmt);
        return updateStmt;
    }

    protected void checkPreconditions(String ... directSqls) {
        this.initSqlId(this.sqlId, 5);
        if (this.eqlBlock != null || directSqls.length > 0) {
            this.initSqlClassPath(5);
            return;
        }
        if (S.isBlank(this.defaultSqlId)) {
            throw new EqlExecuteException("No sqlid defined!");
        }
        this.initSqlId(this.defaultSqlId, 5);
    }

    protected Object runEql() {
        try {
            return this.currRun.getSqlType().isDdl() ? Boolean.valueOf(this.execDdl()) : this.pageExecute();
        }
        catch (Exception ex) {
            if (!this.currRun.getEqlBlock().isOnerrResume()) {
                throw Fucks.fuck(ex);
            }
            logger.warn("execute sql {} error {}", (Object)this.currRun.getPrintSql(), (Object)ex.getMessage());
            return 0;
        }
    }

    private boolean execDdl() {
        boolean bl;
        Statement stmt = null;
        logger.debug("ddl sql for {}: {}", (Object)this.getSqlId(), (Object)this.currRun.getPrintSql());
        try {
            stmt = this.currRun.getConnection().createStatement();
            EqlUtils.setQueryTimeout(this.eqlConfig, stmt);
            bl = stmt.execute(this.currRun.getRunSql());
        }
        catch (SQLException ex) {
            try {
                throw Fucks.fuck(ex);
            }
            catch (Throwable throwable) {
                Closes.closeQuietly(stmt);
                throw throwable;
            }
        }
        Closes.closeQuietly(stmt);
        return bl;
    }

    private Object pageExecute() throws SQLException {
        if (this.page == null || !this.currRun.isLastSelectSql()) {
            return this.execDml();
        }
        if (this.page.getTotalRows() == 0) {
            this.page.setTotalRows(this.executeTotalRowsSql());
        }
        return this.executePageSql();
    }

    private Object executePageSql() throws SQLException {
        EqlRun temp = this.currRun;
        this.currRun = this.dbDialect.createPageSql(this.currRun, this.page);
        new EqlParamsBinder().prepareBindParams(this.eqlBlock.hasIterateOption(), this.currRun);
        Object o = this.execDml();
        this.currRun = temp;
        return o;
    }

    private int executeTotalRowsSql() throws SQLException {
        String blockReturnTypeName = this.currRun.getEqlBlock().getReturnTypeName();
        String returnTypeName = this.rsRetriever.getReturnTypeName();
        Class<?> returnType = this.rsRetriever.getReturnType();
        EqlRun temp = this.currRun;
        this.currRun = this.dbDialect.createTotalSql(this.currRun);
        this.currRun.getEqlBlock().setReturnTypeName("int");
        this.rsRetriever.setReturnType(null);
        this.rsRetriever.setReturnTypeName("int");
        Object totalRows = this.execDml();
        this.currRun = temp;
        this.currRun.getEqlBlock().setReturnTypeName(blockReturnTypeName);
        this.rsRetriever.setReturnTypeName(returnTypeName);
        this.rsRetriever.setReturnType(returnType);
        if (totalRows instanceof Number) {
            return ((Number)totalRows).intValue();
        }
        throw new EqlExecuteException("returned total rows object " + totalRows + " is not a number");
    }

    private Object execDml() throws SQLException {
        Object execRet = this.batch != null ? this.execDmlInBatch() : this.execDmlNoBatch();
        Logs.logResult(this.eqlConfig, this.sqlClassPath, execRet, this.getSqlId(), this.tagSqlId);
        return execRet;
    }

    private Object execDmlInBatch() throws SQLException {
        return this.batch.addBatch(this.currRun);
    }

    private void prepareStmt(EStmt stmt) {
        PreparedStatement ps = null;
        try {
            ps = this.prepareSql();
            stmt.setPreparedStatment(ps);
            stmt.setEqlRun(this.currRun);
            stmt.setSqlClassPath(this.sqlClassPath);
            stmt.setLogger(logger);
            stmt.params(this.params);
            stmt.setEqlTran(this.externalTran != null ? this.externalTran : this.internalTran);
        }
        catch (Exception ex) {
            Closes.closeQuietly(ps);
            throw Fucks.fuck(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object execDmlNoBatch() throws SQLException {
        PreparedStatement ps;
        ResultSet rs;
        block13: {
            block12: {
                Object convertedValue;
                block11: {
                    Object[] arr;
                    rs = null;
                    ps = null;
                    try {
                        ps = this.prepareSql();
                        if (!this.eqlBlock.hasIterateOption()) break block11;
                        int rowCount = 0;
                        if (this.params[0] instanceof Iterable) {
                            Iterator iterator = ((Iterable)this.params[0]).iterator();
                            int i = 0;
                            while (iterator.hasNext()) {
                                this.currRun.bindBatchParams(ps, i, this.sqlClassPath);
                                rowCount += ps.executeUpdate();
                                ++i;
                                iterator.next();
                            }
                        } else if (this.params[0] != null && this.params[0].getClass().isArray()) {
                            arr = (Object[])this.params[0];
                            int ii = arr.length;
                            for (int i = 0; i < ii; ++i) {
                                this.currRun.bindBatchParams(ps, i, this.sqlClassPath);
                                rowCount += ps.executeUpdate();
                            }
                        }
                        arr = Integer.valueOf(rowCount);
                    }
                    catch (Throwable throwable) {
                        Closes.closeQuietly(rs, ps);
                        throw throwable;
                    }
                    Closes.closeQuietly(rs, ps);
                    return arr;
                }
                this.currRun.bindParams(ps, this.sqlClassPath);
                if (this.currRun.getSqlType() != EqlType.SELECT) break block12;
                rs = ps.executeQuery();
                if (this.fetchSize > 0) {
                    rs.setFetchSize(this.fetchSize);
                }
                ResultSet wrapRs = CodeDescs.codeDescWrap(this.currRun, this.eqlBlock, this.eqlConfig, this.sqlClassPath, rs, this.tagSqlId);
                Object object = convertedValue = this.rsRetriever.convert(wrapRs, this.currRun);
                Closes.closeQuietly(rs, ps);
                return object;
            }
            if (!this.currRun.getSqlType().isProcedure()) break block13;
            Object object = new EqlProc(this.currRun, this.rsRetriever).dealProcedure(ps);
            Closes.closeQuietly(rs, ps);
            return object;
        }
        Integer n = ps.executeUpdate();
        Closes.closeQuietly(rs, ps);
        return n;
    }

    private PreparedStatement prepareSql() throws SQLException {
        this.createConn();
        return EqlUtils.prepareSQL(this.sqlClassPath, this.eqlConfig, this.currRun, this.getSqlId(), this.tagSqlId);
    }

    public Eql returnType(Class<?> returnType) {
        this.rsRetriever.setReturnType(returnType);
        return this;
    }

    public Eql returnType(EqlRowMapper eqlRowMapper) {
        this.rsRetriever.setEqlRowMapper(eqlRowMapper);
        return this;
    }

    private void initSqlClassPath(int level) {
        this.sqlClassPath = Strings.isNullOrEmpty((String)this.sqlClassPath) ? C.getSqlClassPath(level, this.getEqlExtension()) : this.sqlClassPath;
    }

    protected void initSqlId(String sqlId, int level) {
        if (S.isBlank(sqlId)) {
            return;
        }
        this.initSqlClassPath(level + 1);
        this.eqlBlock = this.eqlConfig.getSqlResourceLoader().loadEqlBlock(this.sqlClassPath, sqlId);
        this.rsRetriever.setEqlBlock(this.eqlBlock);
    }

    private String getEqlExtension() {
        String eqlExtension = this.eqlConfig.getStr("eql.extension");
        return eqlExtension == null ? "eql" : eqlExtension;
    }

    public Eql useSqlFile(Class<?> sqlBoundClass) {
        this.sqlClassPath = sqlBoundClass.getName().replace('.', '/') + "." + this.getEqlExtension();
        return this;
    }

    public Eql useSqlFile(String sqlClassPath) {
        this.sqlClassPath = sqlClassPath;
        return this;
    }

    public Eql id(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql merge(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql replace(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql update(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql insert(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql delete(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql select(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public Eql selectFirst(String sqlId) {
        this.sqlId = sqlId;
        this.limit(1);
        return this;
    }

    public Eql procedure(String sqlId) {
        this.sqlId = sqlId;
        return this;
    }

    public String getSqlId() {
        return this.eqlBlock.getSqlId();
    }

    protected void tranStart() {
        if (this.batch != null) {
            return;
        }
        if (this.externalTran != null) {
            return;
        }
        if (this.internalTran != null) {
            return;
        }
        if (EqlTransactionManager.isEqlTransactionEnabled()) {
            this.externalTran = EqlTransactionManager.getTran(this.eqlConfig);
            if (this.externalTran != null) {
                return;
            }
            this.externalTran = Eql.newTran(this.eqlConfig);
            EqlTransactionManager.setTran(this.eqlConfig, this.externalTran);
            return;
        }
        this.internalTran = Eql.newTran(this.eqlConfig);
        this.internalTran.start();
    }

    protected void tranCommit() {
        if (this.batch != null) {
            return;
        }
        if (this.externalTran != null) {
            return;
        }
        this.internalTran.commit();
    }

    protected void tranRollback() {
        if (this.batch != null) {
            return;
        }
        if (this.externalTran != null) {
            return;
        }
        if (this.internalTran != null) {
            this.internalTran.rollback();
        }
    }

    private void tranClose() {
        if (this.internalTran != null) {
            Closes.closeQuietly(this.internalTran);
        }
        this.internalTran = null;
    }

    public EqlTran newTran() {
        EqlTran tran = Eql.newTran(this.eqlConfig);
        this.useTran(tran);
        return tran;
    }

    public Eql useTran(EqlTran tran) {
        this.externalTran = tran;
        return this;
    }

    public Eql useBatch(EqlBatch eqlBatch) {
        this.batch = eqlBatch;
        return this;
    }

    public static EqlTran newTran(EqlConfigDecorator eqlConfig) {
        return EqlConfigManager.getConfig(eqlConfig).createTran();
    }

    public EqlConfig getEqlConfig() {
        return this.eqlConfig;
    }

    public String getSqlPath() {
        return this.sqlClassPath;
    }

    public Eql params(Object ... params) {
        this.params = params;
        return this;
    }

    public Eql limit(EqlPage page) {
        this.page = page;
        return this;
    }

    public Eql dynamics(Object ... dynamics) {
        this.dynamics = dynamics;
        return this;
    }

    public Eql limit(int maxRows) {
        this.rsRetriever.setMaxRows(maxRows);
        return this;
    }

    public Object[] getParams() {
        return this.params;
    }

    public Logger getLogger() {
        return logger;
    }

    public Eql returnType(String returnTypeName) {
        this.rsRetriever.setReturnTypeName(returnTypeName);
        return this;
    }

    public Eql fetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
        return this;
    }

    public Eql cached(boolean cached) {
        this.cached = cached;
        return this;
    }

    public void resetTran() {
        this.externalTran = null;
        this.internalTran = null;
    }

    public EqlRun getEqlRun() {
        return this.eqlRuns.size() > 0 ? this.eqlRuns.get(this.eqlRuns.size() - 1) : null;
    }
}

