/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.cache;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.n3r.diamond.client.Miner;
import org.n3r.diamond.client.Minerable;
import org.n3r.eql.cache.EqlCacheKey;
import org.n3r.eql.cache.EqlCacheProvider;
import org.n3r.eql.impl.EqlUniqueSqlId;

public class DiamondGuavaCacheProvider
implements EqlCacheProvider {
    public static final String EQL_CACHE = "EQL.CACHE";
    Cache<EqlUniqueSqlId, Cache<EqlCacheKey, Optional<Object>>> cache = CacheBuilder.newBuilder().build();
    Cache<EqlUniqueSqlId, Optional<String>> cachEQLIdVersion = CacheBuilder.newBuilder().build();

    @Override
    public Optional<Object> getCache(EqlCacheKey cacheKey) {
        EqlUniqueSqlId uniquEQLId = cacheKey.getUniquEQLId();
        Optional cachedSqlIdVersion = (Optional)this.cachEQLIdVersion.getIfPresent((Object)uniquEQLId);
        if (cachedSqlIdVersion == null) {
            return null;
        }
        String sqlIdVersion = this.getSqlIdCacheVersion(uniquEQLId);
        if (!StringUtils.equals((CharSequence)sqlIdVersion, (CharSequence)((CharSequence)cachedSqlIdVersion.orNull()))) {
            this.cache.invalidate((Object)uniquEQLId);
            this.cachEQLIdVersion.put((Object)uniquEQLId, (Object)Optional.fromNullable((Object)sqlIdVersion));
            return null;
        }
        Cache subCache = (Cache)this.cache.getIfPresent((Object)uniquEQLId);
        if (subCache == null) {
            return null;
        }
        return (Optional)subCache.getIfPresent((Object)cacheKey);
    }

    @Override
    public void setCache(EqlCacheKey cacheKey, Object result) {
        final EqlUniqueSqlId uniquEQLId = cacheKey.getUniquEQLId();
        try {
            Cache subCache = (Cache)this.cache.get((Object)uniquEQLId, (Callable)new Callable<Cache<EqlCacheKey, Optional<Object>>>(){

                @Override
                public Cache<EqlCacheKey, Optional<Object>> call() throws Exception {
                    String sqlIdVersion = DiamondGuavaCacheProvider.this.getSqlIdCacheVersion(uniquEQLId);
                    DiamondGuavaCacheProvider.this.cachEQLIdVersion.put((Object)uniquEQLId, (Object)Optional.fromNullable((Object)sqlIdVersion));
                    Cache subCache = CacheBuilder.newBuilder().build();
                    return subCache;
                }
            });
            subCache.put((Object)cacheKey, (Object)Optional.fromNullable((Object)result));
        }
        catch (ExecutionException e) {
            // empty catch block
        }
    }

    private String getSqlIdCacheVersion(EqlUniqueSqlId uniquEQLId) {
        String dataId = uniquEQLId.getSqlClassPath().replaceAll("/", ".");
        Minerable sqlFileProperties = new Miner().getMiner(EQL_CACHE, dataId);
        String key = uniquEQLId.getSqlId() + ".cacheVersion";
        return sqlFileProperties.getString(key);
    }
}

