/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.codedesc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.n3r.eql.codedesc.CodeDesc;
import org.n3r.eql.codedesc.CodeDescs;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.Fucks;
import org.n3r.eql.util.O;
import org.n3r.eql.util.Rs;
import org.n3r.eql.util.S;

public class CodeDescResultSetHandler
implements InvocationHandler {
    final List<CodeDesc> codeDescs;
    final EqlConfigDecorator eqlConfig;
    final String sqlClassPath;
    final EqlRun currEqlRun;
    final ResultSet resultSet;
    final Map<String, Integer> codeIndex = new HashMap<String, Integer>();
    private String tagSqlId;

    public CodeDescResultSetHandler(EqlRun currEqlRun, EqlConfigDecorator eqlConfig, String sqlClassPath, ResultSet resultSet, List<CodeDesc> codeDescs, String tagSqlId) {
        this.currEqlRun = currEqlRun;
        this.eqlConfig = eqlConfig;
        this.sqlClassPath = sqlClassPath;
        this.resultSet = resultSet;
        this.codeDescs = codeDescs;
        this.tagSqlId = tagSqlId;
        this.createCodeIndex();
    }

    private void createCodeIndex() {
        for (CodeDesc codeDesc : this.codeDescs) {
            this.codeIndex.put(codeDesc.getColumnName(), this.findCodeIndex(codeDesc.getColumnName()));
        }
    }

    private int findCodeIndex(String columnName) {
        try {
            ResultSetMetaData metaData = this.resultSet.getMetaData();
            int columnCount = metaData.getColumnCount();
            for (int i = 1; i <= columnCount; ++i) {
                String lookupColumnName = Rs.lookupColumnName(metaData, i);
                if (!S.equalsIgnoreCase(columnName, lookupColumnName)) continue;
                for (int j = i - 1; j >= 1; --j) {
                    String jColumnName = Rs.lookupColumnName(metaData, j);
                    if (this.codeDescsContainsColumnName(jColumnName)) continue;
                    return j;
                }
            }
            throw new EqlExecuteException("unable to find code column");
        }
        catch (SQLException e) {
            throw Fucks.fuck(e);
        }
    }

    private boolean codeDescsContainsColumnName(String jColumnName) {
        for (CodeDesc codeDesc : this.codeDescs) {
            if (!codeDesc.getColumnName().equalsIgnoreCase(jColumnName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = method.invoke((Object)this.resultSet, args);
        if (!O.in(method.getName(), "getString", "getObject")) {
            return result;
        }
        String columnName = this.parseArgName(args[0]);
        if (columnName == null) {
            return result;
        }
        CodeDesc codeDesc = this.findCodeDesc(columnName);
        if (codeDesc == null) {
            return result;
        }
        String code = this.resultSet.getString(this.codeIndex.get(codeDesc.getColumnName()));
        return CodeDescs.map(this.currEqlRun, this.eqlConfig, this.sqlClassPath, codeDesc, code, this.tagSqlId);
    }

    private CodeDesc findCodeDesc(String columnName) {
        for (CodeDesc codeDesc : this.codeDescs) {
            if (!S.equalsIgnoreCase(columnName, codeDesc.getColumnName())) continue;
            return codeDesc;
        }
        return null;
    }

    private String parseArgName(Object arg) throws SQLException {
        if (arg instanceof String) {
            return (String)arg;
        }
        if (arg instanceof Integer) {
            Integer index = (Integer)arg;
            return Rs.lookupColumnName(this.resultSet.getMetaData(), index);
        }
        return null;
    }

    public ResultSet createProxy() {
        return (ResultSet)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ResultSet.class}, (InvocationHandler)this);
    }
}

