/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor;

import java.sql.Connection;
import java.util.Set;
import org.n3r.eql.DbDialect;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.config.EqlConfigManager;
import org.n3r.eql.dbfieldcryptor.SecretFieldsConfigable;
import org.n3r.eql.dbfieldcryptor.SensitiveCryptor;
import org.n3r.eql.dbfieldcryptor.parser.ParserCache;
import org.n3r.eql.dbfieldcryptor.proxy.ConnectionHandler;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.util.S;

public class EqlSecretFieldsConnectionProxy
implements EqlConnection {
    private EqlConnection eqlConnection;
    private ParserCache parserCache;
    private SensitiveCryptor sensitiveCryptor;
    public static ThreadLocal<EqlConfig> threadLocal;

    @Override
    public void initialize(EqlConfig eqlConfig) {
        String sensitiveCryptorImpl;
        SecretFieldsConfigable secretFieldsConfigable;
        Set<String> secretFieldsConfig;
        this.eqlConnection = EqlConfigManager.createEqlConnection(eqlConfig, "proxy.connection.impl");
        this.eqlConnection.initialize(eqlConfig);
        threadLocal = new ThreadLocal();
        threadLocal.set(eqlConfig);
        String secretFieldsConfigableImpl = eqlConfig.getStr("secret.fields.configable.impl");
        if (S.isNotEmpty(secretFieldsConfigableImpl) && (secretFieldsConfig = (secretFieldsConfigable = (SecretFieldsConfigable)Reflect.on(secretFieldsConfigableImpl).create().get()).getSecretFieldsConfig()) != null && !secretFieldsConfig.isEmpty()) {
            this.parserCache = new ParserCache(secretFieldsConfig);
        }
        if (S.isNotEmpty(sensitiveCryptorImpl = eqlConfig.getStr("sensitive.cryptor.impl"))) {
            this.sensitiveCryptor = (SensitiveCryptor)Reflect.on(sensitiveCryptorImpl).create().get();
        }
        threadLocal.remove();
        threadLocal = null;
    }

    @Override
    public String getDbName(EqlConfig eqlConfig, EqlRun eqlRun) {
        return this.eqlConnection.getDbName(eqlConfig, eqlRun);
    }

    @Override
    public Connection getConnection(String dbName) {
        Connection connection = this.eqlConnection.getConnection(dbName);
        DbDialect dbDialect = DbDialect.parseDbType(connection);
        if (this.parserCache == null || this.sensitiveCryptor == null) {
            return null;
        }
        Connection connectionProxy = new ConnectionHandler(connection, this.sensitiveCryptor, this.parserCache, dbDialect).createConnectionProxy();
        return connectionProxy;
    }

    @Override
    public void destroy() {
        this.eqlConnection.destroy();
    }

    @Override
    public String getDriverName() {
        return this.eqlConnection.getDriverName();
    }

    @Override
    public String getJdbcUrl() {
        return this.eqlConnection.getJdbcUrl();
    }
}

