/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.parser;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import org.n3r.eql.DbDialect;
import org.n3r.eql.dbfieldcryptor.parser.MySqlSensitiveFieldsParser;
import org.n3r.eql.dbfieldcryptor.parser.OracleSensitiveFieldsParser;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserCache {
    Logger logger = LoggerFactory.getLogger(ParserCache.class);
    final Set<String> secureFieldsConfig;
    final LoadingCache<DbIdSql, Optional<SensitiveFieldsParser>> cache;

    public ParserCache(Set<String> secureFieldsConfig) {
        this.secureFieldsConfig = secureFieldsConfig;
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<DbIdSql, Optional<SensitiveFieldsParser>>(){

            public Optional<SensitiveFieldsParser> load(DbIdSql dbIdSql) {
                return Optional.fromNullable((Object)ParserCache.this.getParser(dbIdSql));
            }
        });
    }

    private SensitiveFieldsParser getParser(DbIdSql dbIdSql) {
        String databaseId = dbIdSql.getDatabaseId();
        String sql = dbIdSql.getSql();
        try {
            SensitiveFieldsParser parser = this.getSensitiveFieldsParser(databaseId, sql);
            if (parser == null) {
                return null;
            }
            if (parser.haveNonSecureFields()) {
                return null;
            }
            return parser;
        }
        catch (Exception ex) {
            this.logger.warn("parse sql [{}] failed {}", (Object)sql, (Object)ex.getMessage());
            return null;
        }
    }

    private SensitiveFieldsParser getSensitiveFieldsParser(String dbId, String sql) {
        if ("oracle".equals(dbId)) {
            return OracleSensitiveFieldsParser.parseSql(sql, this.secureFieldsConfig);
        }
        if ("mysql".equals(dbId)) {
            return MySqlSensitiveFieldsParser.parseSql(sql, this.secureFieldsConfig);
        }
        return null;
    }

    public SensitiveFieldsParser getParser(DbDialect dbDialect, String sql) {
        return (SensitiveFieldsParser)((Optional)this.cache.getUnchecked((Object)new DbIdSql(dbDialect.getDatabaseId(), sql))).orNull();
    }

    static class DbIdSql {
        final String databaseId;
        final String sql;

        public DbIdSql(String databaseId, String sql) {
            this.databaseId = databaseId;
            this.sql = sql;
        }

        public String getDatabaseId() {
            return this.databaseId;
        }

        public String getSql() {
            return this.sql;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DbIdSql that = (DbIdSql)o;
            if (!this.databaseId.equals(that.databaseId)) {
                return false;
            }
            return this.sql.equals(that.sql);
        }

        public int hashCode() {
            int result = this.databaseId.hashCode();
            result = 31 * result + this.sql.hashCode();
            return result;
        }
    }
}

