/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import org.n3r.eql.dbfieldcryptor.SensitiveCryptor;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.n3r.eql.dbfieldcryptor.proxy.ResultSetHandler;
import org.n3r.eql.util.O;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PreparedStmtHandler
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(PreparedStmtHandler.class);
    private final PreparedStatement pstmt;
    private final SensitiveCryptor cryptor;
    private final SensitiveFieldsParser parser;

    public PreparedStmtHandler(PreparedStatement pStmt, SensitiveFieldsParser parser, SensitiveCryptor cryptor) {
        this.pstmt = pStmt;
        this.parser = parser;
        this.cryptor = cryptor;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (O.in(method.getName(), "setString", "setObject") && this.parser.inBindIndices((Integer)args[0])) {
            try {
                args[1] = args[1] == null ? null : this.cryptor.encrypt(args[1].toString());
            }
            catch (Exception e) {
                this.logger.warn("Encrypt parameter #{}# error", args[1], (Object)e);
            }
        }
        Object result = method.invoke((Object)this.pstmt, args);
        if (O.in(method.getName(), "executeQuery", "getResultSet") && this.parser.getSecureResultIndices().size() > 0) {
            result = new ResultSetHandler((ResultSet)result, this.parser, this.cryptor).createResultSetProxy();
        }
        return result;
    }

    public PreparedStatement createPreparedStatementProxy() {
        return (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{PreparedStatement.class}, (InvocationHandler)this);
    }
}

