/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.Closes;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.Fucks;
import org.n3r.eql.util.Logs;
import org.slf4j.Logger;

public class EqlBatch {
    private int maxBatches;
    private int currentBatches;
    private int totalBatches;
    private List<PreparedStatement> batchedPs;
    private Map<String, PreparedStatement> batchedMap;
    private String sqlClassPath;
    private EqlConfig eqlConfig;
    private String sqlId;
    private String tagSqlId;

    public EqlBatch() {
        this(0);
    }

    public EqlBatch(int maxBatches) {
        this.maxBatches = maxBatches;
        this.batchedPs = Lists.newArrayList();
        this.batchedMap = Maps.newHashMap();
    }

    public void prepare(String sqlClassPath, EqlConfig eqlConfig, String sqlId, String tagSqlId) {
        this.sqlClassPath = sqlClassPath;
        this.eqlConfig = eqlConfig;
        this.sqlId = sqlId;
        this.tagSqlId = tagSqlId;
    }

    public int addBatch(EqlRun eqlRun) throws SQLException {
        PreparedStatement ps = this.batchedMap.get(eqlRun.getRunSql());
        if (ps == null) {
            ps = EqlUtils.prepareSQL(this.sqlClassPath, this.eqlConfig, eqlRun, this.sqlId, this.tagSqlId);
            this.batchedMap.put(eqlRun.getRunSql(), ps);
            this.batchedPs.add(ps);
        }
        eqlRun.bindParams(ps, this.sqlClassPath);
        ps.addBatch();
        ++this.currentBatches;
        return this.maxBatches > 0 && this.currentBatches >= this.maxBatches ? this.executeBatch(false) : 0;
    }

    public int executeBatch() {
        return this.executeBatch(true);
    }

    public int executeBatch(boolean cleanup) {
        try {
            int totalRowCount = 0;
            for (PreparedStatement ps : this.batchedPs) {
                int[] rowCounts = ps.executeBatch();
                for (int j = 0; j < rowCounts.length; ++j) {
                    if (rowCounts[j] == -2) continue;
                    if (rowCounts[j] == -3) {
                        throw new EqlExecuteException("The batched statement at index " + j + " failed to execute.");
                    }
                    totalRowCount += rowCounts[j];
                }
            }
            this.totalBatches += totalRowCount;
            Logger eqlLogger = Logs.createLogger(this.eqlConfig, this.sqlClassPath, this.sqlId, this.tagSqlId, "executeBatch");
            eqlLogger.debug("current batches {} total batches {}", (Object)totalRowCount, (Object)this.totalBatches);
            this.currentBatches = 0;
            int n = this.totalBatches;
            return n;
        }
        catch (SQLException ex) {
            this.cleanupBatch();
            throw Fucks.fuck(ex);
        }
        finally {
            if (cleanup) {
                this.cleanupBatch();
            }
        }
    }

    public void cleanupBatch() {
        for (PreparedStatement ps : this.batchedPs) {
            Closes.closeQuietly(ps);
        }
        this.batchedPs.clear();
    }
}

