/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix;

import com.alibaba.druid.pool.DruidDataSource;
import com.google.common.base.Splitter;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.matrix.sqlparser.MatrixSqlParseNoResult;
import org.n3r.eql.matrix.sqlparser.MatrixSqlParseResult;
import org.n3r.eql.matrix.sqlparser.MatrixSqlParser;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.util.O;
import org.n3r.eql.util.Pair;
import org.n3r.eql.util.PropertyValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlMatrixConnection
implements EqlConnection {
    public static final String DEFAULT = "default";
    LoadingCache<String, DruidDataSource> dataSourceCache;
    static Logger logger = LoggerFactory.getLogger(EqlMatrixConnection.class);
    private String url;
    LoadingCache<Pair<EqlConfig, String>, MatrixSqlParseResult> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Pair<EqlConfig, String>, MatrixSqlParseResult>(){

        public MatrixSqlParseResult load(Pair<EqlConfig, String> key) throws Exception {
            return new MatrixSqlParser().parse((EqlConfig)key._1, (String)key._2);
        }
    });
    static ThreadLocal<String> dbNameTL = new ThreadLocal();

    @Override
    public void initialize(EqlConfig eqlConfig) {
        this.url = eqlConfig.getStr("url");
        final Map<String, String> params = eqlConfig.params();
        this.dataSourceCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, DruidDataSource>(){

            public DruidDataSource load(final String database) throws Exception {
                return O.populate(new DruidDataSource(), params, new PropertyValueFilter(){

                    @Override
                    public String filter(String propertyValue) {
                        return EqlMatrixConnection.parseParameter(propertyValue, database);
                    }
                });
            }
        });
    }

    public static void chooseDbName(String dbName) {
        dbNameTL.set(dbName);
    }

    @Override
    public String getDbName(EqlConfig eqlConfig, EqlRun eqlRun) {
        MatrixSqlParseResult result = (MatrixSqlParseResult)this.cache.getUnchecked(Pair.of(eqlConfig, eqlRun.getRunSql()));
        if (result instanceof MatrixSqlParseNoResult) {
            return DEFAULT;
        }
        return result.getDatabaseName(eqlRun);
    }

    @Override
    public Connection getConnection(String dbName) {
        String localDbName = !DEFAULT.equals(dbName) ? dbName : (dbNameTL.get() != null ? dbNameTL.get() : DEFAULT);
        try {
            DruidDataSource dataSource = (DruidDataSource)this.dataSourceCache.getUnchecked((Object)localDbName);
            logger.debug("use database [{}]", (Object)localDbName);
            return dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new EqlExecuteException("unable to find database " + localDbName, e);
        }
    }

    private static String parseParameter(String param, String database) {
        if (param == null || param.length() == 0) {
            return "";
        }
        StringBuilder parsed = new StringBuilder();
        Splitter.MapSplitter splitter = Splitter.on((char)',').trimResults().omitEmptyStrings().withKeyValueSeparator("->");
        int startPos = 0;
        while (startPos < param.length()) {
            int rightBracePos;
            int leftBracePos = param.indexOf(123, startPos);
            if (leftBracePos < 0) {
                parsed.append(param.substring(startPos));
                break;
            }
            if (leftBracePos > 0) {
                parsed.append(param.substring(startPos, leftBracePos));
            }
            if ((rightBracePos = param.indexOf(125, leftBracePos)) < 0) {
                logger.warn("invalid parameter format: " + param);
                return param;
            }
            String map = param.substring(leftBracePos + 1, rightBracePos);
            Map data = splitter.split((CharSequence)map);
            String specified = (String)data.get(database);
            if (specified == null) {
                specified = (String)data.get(DEFAULT);
            }
            if (specified == null) {
                logger.warn("invalid parameter mapping format: " + param);
                return param;
            }
            parsed.append(specified);
            startPos = rightBracePos + 1;
        }
        return parsed.toString();
    }

    @Override
    public void destroy() {
        ConcurrentMap map = this.dataSourceCache.asMap();
        for (String databaseName : map.keySet()) {
            DruidDataSource druidDataSource = (DruidDataSource)map.get(databaseName);
            try {
                druidDataSource.close();
            }
            catch (Exception e) {}
        }
        this.dataSourceCache.invalidateAll();
        this.dataSourceCache = null;
    }

    @Override
    public String getDriverName() {
        return this.url;
    }

    @Override
    public String getJdbcUrl() {
        return this.url;
    }
}

