/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.matrix;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.n3r.eql.matrix.MatrixTableFieldValue;
import org.n3r.eql.matrix.RealPartition;
import org.n3r.eql.matrix.func.MiddleFunction;
import org.n3r.eql.matrix.func.ModFunction;
import org.n3r.eql.matrix.func.PostFunction;
import org.n3r.eql.matrix.func.PrefixFunction;
import org.n3r.eql.matrix.func.RangeFunction;
import org.n3r.eql.matrix.func.ValFunction;
import org.n3r.eql.matrix.impl.GotoRealPartition;
import org.n3r.eql.matrix.impl.MatrixFunction;
import org.n3r.eql.matrix.impl.MatrixMapper;
import org.n3r.eql.matrix.impl.MatrixRule;
import org.n3r.eql.matrix.mapper.DefaultMatrixMapper;

public class RulesSet {
    private Map<String, Class<? extends MatrixFunction>> funcAlias = Maps.newHashMap();
    private Map<String, Class<? extends MatrixMapper>> mapperAlias = Maps.newHashMap();
    private Map<Integer, MatrixRule> rulesMap = Maps.newHashMap();
    private List<MatrixRule> rules = Lists.newArrayList();

    public RulesSet() {
        this.funcAlias.put("pre", PrefixFunction.class);
        this.funcAlias.put("mid", MiddleFunction.class);
        this.funcAlias.put("post", PostFunction.class);
        this.funcAlias.put("mod", ModFunction.class);
        this.funcAlias.put("val", ValFunction.class);
        this.funcAlias.put("range", RangeFunction.class);
        this.mapperAlias.put("map", DefaultMatrixMapper.class);
    }

    public Class<? extends MatrixFunction> getFunctionAlias(String aliasName) {
        return this.funcAlias.get(aliasName);
    }

    public Class<? extends MatrixMapper> getMapAlias(String mapperAliasName) {
        return this.mapperAlias.get(mapperAliasName);
    }

    public void addAlias(String aliasName, Class<? extends MatrixFunction> fullClass) {
        this.funcAlias.put(aliasName, fullClass);
    }

    public void addRule(MatrixRule matrixRule) {
        this.rules.add(matrixRule);
        this.rulesMap.put(matrixRule.ruleNo, matrixRule);
    }

    public RealPartition find(MatrixTableFieldValue ... fieldValues) {
        for (MatrixRule rule : this.rules) {
            RealPartition realPartition = rule.go(fieldValues);
            if (realPartition == null) continue;
            if (realPartition instanceof GotoRealPartition) {
                GotoRealPartition gotoRealPartition = (GotoRealPartition)realPartition;
                int gotoRuleNum = gotoRealPartition.getGotoRuleNum();
                MatrixRule gotoRule = this.rulesMap.get(gotoRuleNum);
                if (gotoRule != null) {
                    return gotoRule.go(fieldValues);
                }
                throw new RuntimeException("rule " + gotoRuleNum + " is undefinned");
            }
            return realPartition;
        }
        return null;
    }

    public MatrixRule getRule(int ruleNo) {
        return this.rulesMap.get(ruleNo);
    }

    public boolean relativeTo(String tableName) {
        for (MatrixRule rule : this.rules) {
            if (!rule.relativeTo(tableName)) continue;
            return true;
        }
        return false;
    }

    public boolean relativeTo(String tableName, String columnName) {
        for (MatrixRule rule : this.rules) {
            if (!rule.relativeTo(tableName, columnName)) continue;
            return true;
        }
        return false;
    }
}

