/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.param;

import com.google.common.base.Objects;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.ex.EqlExecuteException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.ParamValueDealer;
import org.n3r.eql.util.Fucks;
import org.n3r.eql.util.Names;

public class EqlParamsBinder {
    private EqlRun eqlRun;
    private List<Object> boundParams;
    private boolean hasIterateOption;

    public void prepareBindParams(boolean hasIterateOption, EqlRun eqlRun) {
        this.hasIterateOption = hasIterateOption;
        this.eqlRun = eqlRun;
        eqlRun.setIterateOption(hasIterateOption);
        this.boundParams = new ArrayList<Object>();
        switch (eqlRun.getPlaceHolderType()) {
            case AUTO_SEQ: {
                for (int i = 0; i < eqlRun.getPlaceholderNum(); ++i) {
                    this.setParam(i, this.getParamByIndex(i), ParamExtra.Normal);
                }
                break;
            }
            case MANU_SEQ: {
                for (int i = 0; i < eqlRun.getPlaceholderNum(); ++i) {
                    this.setParam(i, this.findParamBySeq(i + 1), ParamExtra.Normal);
                }
                break;
            }
            case VAR_NAME: {
                for (int i = 0; i < eqlRun.getPlaceholderNum(); ++i) {
                    this.setParam(i, this.findParamByName(i), ParamExtra.Normal);
                }
                break;
            }
        }
        this.bindExtraParams();
        eqlRun.setBoundParams(this.boundParams);
    }

    private void bindExtraParams() {
        Object[] extraBindParams = this.eqlRun.getExtraBindParams();
        if (extraBindParams == null) {
            return;
        }
        for (int i = this.eqlRun.getPlaceholderNum(); i < this.eqlRun.getPlaceholderNum() + extraBindParams.length; ++i) {
            this.setParam(i, extraBindParams[i - this.eqlRun.getPlaceholderNum()], ParamExtra.Extra);
        }
    }

    private void setParam(int index, Object value, ParamExtra extra) {
        EqlParamPlaceholder placeHolder = this.eqlRun.getPlaceHolder(index);
        try {
            switch (extra) {
                case Extra: {
                    this.setParamValue(placeHolder, index, value);
                    break;
                }
                default: {
                    this.setParamEx(placeHolder, index, value);
                    break;
                }
            }
        }
        catch (SQLException e) {
            throw Fucks.fuck(e);
        }
    }

    private void setParamValue(EqlParamPlaceholder placeHolder, int index, Object value) throws SQLException {
        if (this.hasIterateOption) {
            List values = (List)value;
            Object[] boundParam = new Object[values.size()];
            Object[] paramsValue = new Object[boundParam.length];
            int ii = boundParam.length;
            for (int i = 0; i < ii; ++i) {
                ParamValueDealer paramValueDealer = new ParamValueDealer(placeHolder);
                paramValueDealer.dealSingleValue(values.get(i));
                boundParam[i] = paramValueDealer.getBoundParam();
                paramsValue[i] = paramValueDealer.getParamValue();
            }
            this.boundParams.add(boundParam);
            this.eqlRun.addRealParam(index + 1, paramsValue);
        } else {
            ParamValueDealer paramValueDealer = new ParamValueDealer(placeHolder);
            paramValueDealer.dealSingleValue(value);
            this.boundParams.add(paramValueDealer.getBoundParam());
            this.eqlRun.addRealParam(index + 1, paramValueDealer.getParamValue());
        }
    }

    private void setParamEx(EqlParamPlaceholder placeHolder, int index, Object value) throws SQLException {
        if (this.registerOut(index)) {
            return;
        }
        this.setParamValue(placeHolder, index, value);
    }

    private boolean registerOut(int index) throws SQLException {
        EqlParamPlaceholder.InOut inOut = this.eqlRun.getPlaceHolders()[index].getInOut();
        if (this.eqlRun.getSqlType().isProcedure() && inOut != EqlParamPlaceholder.InOut.IN) {
            this.eqlRun.registerOutParameter(index + 1, 12);
        }
        return inOut == EqlParamPlaceholder.InOut.OUT;
    }

    private Object findParamByName(int index) {
        String varName = this.eqlRun.getPlaceHolders()[index].getPlaceholder();
        ExpressionEvaluator evaluator = this.eqlRun.getEqlConfig().getExpressionEvaluator();
        Object property = evaluator.eval(varName, this.eqlRun);
        if (!this.hasIterateOption && property != null || this.hasIterateOption && !this.isAllNullInBatchOption(property)) {
            return property;
        }
        String propertyName = Names.underscoreNameToPropertyName(varName);
        return Objects.equal((Object)propertyName, (Object)varName) ? property : evaluator.eval(propertyName, this.eqlRun);
    }

    private boolean isAllNullInBatchOption(Object property) {
        List listProperties = (List)property;
        for (Object object : listProperties) {
            if (object == null) continue;
            return false;
        }
        return true;
    }

    private Object getParamByIndex(int index) {
        EqlParamPlaceholder[] placeHolders = this.eqlRun.getPlaceHolders();
        if (index < placeHolders.length && this.eqlRun.getSqlType().isProcedure() && placeHolders[index].getInOut() == EqlParamPlaceholder.InOut.OUT) {
            return null;
        }
        if (this.hasIterateOption) {
            throw new EqlExecuteException("bad parameters when batch option is set");
        }
        Object[] params = this.eqlRun.getParams();
        if (params != null && index < params.length) {
            return params[index];
        }
        throw new EqlExecuteException("[" + this.eqlRun.getSqlId() + "] lack parameters at runtime");
    }

    private Object findParamBySeq(int index) {
        return this.getParamByIndex(this.eqlRun.getPlaceHolders()[index - 1].getSeq() - 1);
    }

    private static enum ParamExtra {
        Extra,
        Normal;

    }
}

