/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.param;

import java.sql.Timestamp;
import java.util.Date;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.InternalValueable;
import org.n3r.eql.util.S;

public class ParamValueDealer {
    private EqlParamPlaceholder placeHolder;
    private Object boundParam;
    private Object paramValue;

    public ParamValueDealer(EqlParamPlaceholder placeHolder) {
        this.placeHolder = placeHolder;
    }

    public Object getBoundParam() {
        return this.boundParam;
    }

    public Object getParamValue() {
        return this.paramValue;
    }

    public void dealSingleValue(Object value) {
        this.boundParam = value;
        this.paramValue = value;
        if (value != null) {
            if (value instanceof Date) {
                Timestamp date = new Timestamp(((Date)value).getTime());
                this.boundParam = S.toDateTimeStr(date);
                this.paramValue = date;
            } else if (value.getClass().isEnum()) {
                if (value instanceof InternalValueable) {
                    this.boundParam = this.paramValue = ((InternalValueable)value).internalValue();
                }
            } else {
                if (this.placeHolder != null && value instanceof CharSequence) {
                    String strValue = value.toString();
                    if (this.placeHolder.isLob()) {
                        this.paramValue = S.toBytes(strValue);
                    } else if (this.placeHolder.getLike() == EqlParamPlaceholder.Like.Like) {
                        this.paramValue = this.tryAddLeftAndRightPercent(strValue);
                    } else if (this.placeHolder.getLike() == EqlParamPlaceholder.Like.RightLike) {
                        this.paramValue = this.tryAddRightPercent(strValue);
                    } else if (this.placeHolder.getLike() == EqlParamPlaceholder.Like.LeftLike) {
                        this.paramValue = this.tryAddLeftPercent(strValue);
                    } else if (this.placeHolder.isNumberColumn() && strValue.trim().length() == 0) {
                        this.paramValue = null;
                    }
                }
                this.boundParam = this.paramValue;
            }
        }
    }

    private String tryAddLeftPercent(String strValue) {
        return (strValue.startsWith("%") ? "" : "%") + strValue;
    }

    private String tryAddRightPercent(String strValue) {
        return strValue + (strValue.endsWith("%") ? "" : "%");
    }

    private String tryAddLeftAndRightPercent(String strValue) {
        return (strValue.startsWith("%") ? "" : "%") + strValue + (strValue.endsWith("%") ? "" : "%");
    }
}

