/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.n3r.eql.EqlPage;
import org.n3r.eql.cache.EqlCacheKey;
import org.n3r.eql.cache.EqlCacheProvider;
import org.n3r.eql.cache.EqlCacheSettings;
import org.n3r.eql.codedesc.CodeDesc;
import org.n3r.eql.codedesc.CodeDescs;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.impl.DefaultDynamicLanguageDriver;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.map.EqlType;
import org.n3r.eql.param.EqlParamsParser;
import org.n3r.eql.parser.BlockOptionsParser;
import org.n3r.eql.parser.DelaySql;
import org.n3r.eql.parser.DynamicReplacer;
import org.n3r.eql.parser.OptionValueParser;
import org.n3r.eql.parser.Sql;
import org.n3r.eql.util.C;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.O;
import org.n3r.eql.util.S;

public class EqlBlock {
    private Map<String, String> options = Maps.newHashMap();
    private Class<?> returnType;
    private String onerr;
    private String split;
    private List<Sql> sqls = Lists.newArrayList();
    private Collection<String> sqlLines;
    private EqlUniqueSqlId uniqueSqlId;
    private EqlCacheProvider cacheProvider;
    private String returnTypeName;
    private boolean iterateOption;
    private List<CodeDesc> codeDescs;
    private boolean override;

    public EqlBlock(String sqlClassPath, String sqlId, String options, int startLineNo) {
        this.uniqueSqlId = new EqlUniqueSqlId(sqlClassPath, sqlId);
        this.options = BlockOptionsParser.parseOptions(options, new OptionValueParser[0]);
        this.initSomeOptions();
    }

    public EqlBlock() {
        this.uniqueSqlId = new EqlUniqueSqlId("<DirectSql>", "auto");
    }

    private void initSomeOptions() {
        this.onerr = this.options.get("onerr");
        this.returnTypeName = this.options.get("returnType");
        this.iterateOption = this.options.containsKey("iterate");
        this.codeDescs = CodeDescs.parseOption(this, this.options.get("desc"));
        this.returnType = C.tryLoadClass(this.returnTypeName);
        this.override = this.options.containsKey("override");
        this.split = this.options.get("split");
        if (Strings.isNullOrEmpty((String)this.split)) {
            this.split = ";";
        }
        this.initEqlCache(this.options.containsKey("cache"), this.options.get("cacheModel"));
    }

    private void initEqlCache(boolean useCache, String cacheModel) {
        if (Strings.isNullOrEmpty((String)cacheModel) && !useCache) {
            return;
        }
        this.cacheProvider = EqlCacheSettings.getCacheProvider(this.uniqueSqlId, cacheModel);
    }

    public List<Sql> getSqls() {
        return this.sqls;
    }

    public List<EqlRun> createEqlRuns(String tagSqlId, EqlConfigDecorator eqlConfig, Map<String, Object> executionContext, Object[] params, Object[] dynamics, String[] directSqls) {
        return directSqls.length == 0 ? this.createEqlRunsByEqls(tagSqlId, eqlConfig, executionContext, params, dynamics) : this.createEqlRunsByDirectSqls(tagSqlId, eqlConfig, executionContext, params, dynamics, directSqls);
    }

    public List<EqlRun> createEqlRunsByEqls(String tagSqlId, EqlConfigDecorator eqlConfig, Map<String, Object> executionContext, Object[] params, Object[] dynamics) {
        Object paramBean = O.createSingleBean(params);
        ArrayList eqlRuns = Lists.newArrayList();
        EqlRun lastSelectSql = null;
        for (Sql sql : this.sqls) {
            EqlRun eqlRun = this.newEqlRun(tagSqlId, eqlConfig, executionContext, params, dynamics, paramBean);
            String sqlStr = sql.evalSql(eqlRun);
            if (S.isBlank(sqlStr = EqlUtils.trimLastUnusedPart(sqlStr))) continue;
            eqlRuns.add(eqlRun);
            this.addEqlRun(eqlConfig, eqlRun, sqlStr);
            if (eqlRun.getSqlType() != EqlType.SELECT) continue;
            lastSelectSql = eqlRun;
        }
        if (lastSelectSql != null) {
            lastSelectSql.setLastSelectSql(true);
        }
        return eqlRuns;
    }

    private void addEqlRun(EqlConfigDecorator eqlConfig, EqlRun eqlRun, String sqlStr) {
        EqlParamsParser.parseParams(eqlRun, sqlStr);
        new DynamicReplacer().replaceDynamics(eqlConfig, eqlRun);
    }

    public List<EqlRun> createEqlRunsByDirectSqls(String tagSqlId, EqlConfigDecorator eqlConfig, Map<String, Object> executionContext, Object[] params, Object[] dynamics, String[] sqls) {
        Object paramBean = O.createSingleBean(params);
        ArrayList eqlRuns = Lists.newArrayList();
        EqlRun lastSelectSql = null;
        int sqlNo = 0;
        for (String sqlStr : sqls) {
            String seqTagSqlId = sqls.length == 1 ? tagSqlId : tagSqlId + "." + ++sqlNo;
            EqlRun eqlRun = this.newEqlRun(seqTagSqlId, eqlConfig, executionContext, params, dynamics, paramBean);
            Sql sql = new DefaultDynamicLanguageDriver().parse(Lists.newArrayList((Object[])new String[]{sqlStr}));
            String parsedSqlStr = sql.evalSql(eqlRun);
            if (S.isBlank(sqlStr = EqlUtils.trimLastUnusedPart(parsedSqlStr))) continue;
            eqlRuns.add(eqlRun);
            this.addEqlRun(eqlConfig, eqlRun, sqlStr);
            if (eqlRun.getSqlType() != EqlType.SELECT) continue;
            lastSelectSql = eqlRun;
        }
        if (lastSelectSql != null) {
            lastSelectSql.setLastSelectSql(true);
        }
        return eqlRuns;
    }

    private EqlRun newEqlRun(String tagSqlId, EqlConfigDecorator eqlConfig, Map<String, Object> executionContext, Object[] params, Object[] dynamics, Object paramBean) {
        EqlRun eqlRun = new EqlRun();
        eqlRun.setEqlConfig(eqlConfig);
        eqlRun.setTagSqlId(tagSqlId);
        eqlRun.setExecutionContext(executionContext);
        eqlRun.setParams(params);
        eqlRun.setDynamics(dynamics);
        eqlRun.setParamBean(paramBean);
        eqlRun.setEqlBlock(this);
        return eqlRun;
    }

    public boolean isOnerrResume() {
        return "resume".equalsIgnoreCase(this.onerr);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setSqls(List<Sql> sqls) {
        this.sqls = sqls;
    }

    public Collection<? extends String> getSqlLines() {
        return this.sqlLines;
    }

    public void setSqlLines(List<String> sqlLines) {
        this.sqlLines = sqlLines;
    }

    public String getSplit() {
        return this.split;
    }

    public void tryParseSqls() {
        for (Sql sql : this.sqls) {
            if (!(sql instanceof DelaySql)) continue;
            ((DelaySql)sql).parseSql();
        }
    }

    public EqlUniqueSqlId getUniqueSqlId() {
        return this.uniqueSqlId;
    }

    public String getUniqueSqlIdStr() {
        return this.uniqueSqlId.getSqlClassPath() + ":" + this.uniqueSqlId.getSqlId();
    }

    public String getSqlId() {
        return this.uniqueSqlId.getSqlId();
    }

    public Optional<Object> getCachedResult(Object[] params, Object[] dynamics, EqlPage page) {
        EqlUniqueSqlId totalRowSqlId;
        Optional<Object> totalNumber;
        if (this.cacheProvider == null) {
            return null;
        }
        EqlCacheKey cacheKey = new EqlCacheKey(this.uniqueSqlId, params, dynamics, page);
        Optional<Object> cache = this.cacheProvider.getCache(cacheKey);
        if (cache != null && page != null && (totalNumber = this.cacheProvider.getCache(cacheKey = new EqlCacheKey(totalRowSqlId = this.uniqueSqlId.newTotalRowSqlId(), params, dynamics, page))).isPresent()) {
            page.setTotalRows((Integer)totalNumber.get());
        }
        return cache;
    }

    public void cacheResult(EqlRun currRun, EqlPage page) {
        if (this.cacheProvider == null) {
            return;
        }
        if (!currRun.isLastSelectSql()) {
            return;
        }
        EqlCacheKey cacheKey = new EqlCacheKey(this.uniqueSqlId, currRun.getParams(), currRun.getDynamics(), page);
        this.cacheProvider.setCache(cacheKey, currRun.getResult());
        if (page != null) {
            EqlUniqueSqlId totalRowSqlId = this.uniqueSqlId.newTotalRowSqlId();
            cacheKey = new EqlCacheKey(totalRowSqlId, currRun.getParams(), currRun.getDynamics(), page);
            this.cacheProvider.setCache(cacheKey, page.getTotalRows());
        }
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public void setReturnTypeName(String returnTypeName) {
        this.returnTypeName = returnTypeName;
    }

    public boolean hasIterateOption() {
        return this.iterateOption;
    }

    public List<CodeDesc> getCodeDescs() {
        return this.codeDescs;
    }

    public boolean isOverride() {
        return this.override;
    }

    public void setOverride(boolean override) {
        this.override = override;
    }
}

