/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.S;

public class ForPart
implements EqlPart {
    private MultiPart part;
    private String item;
    private String index;
    private String collection;
    private String open;
    private String separator;
    private String close;
    private static Pattern PARAM_PATTERN = Pattern.compile("#\\s*(.+?)\\s*#");
    private static Pattern DYNAMIC_PATTERN = Pattern.compile("\\$\\s*(.+?)\\s*\\$");

    public ForPart(MultiPart part, String item, String index, String collection, String open, String separator, String close) {
        this.part = part;
        this.item = item;
        this.index = index;
        this.collection = collection;
        this.open = open;
        this.separator = separator;
        this.close = close;
    }

    public MultiPart getSqlPart() {
        return this.part;
    }

    @Override
    public String evalSql(EqlRun eqlRun) {
        StringBuilder str = new StringBuilder(this.open).append(' ');
        Iterable<?> items = EqlUtils.evalCollection(this.collection, eqlRun);
        if (items == null) {
            return "";
        }
        Map<String, Object> preContext = eqlRun.getExecutionContext();
        HashMap<String, Object> context = new HashMap<String, Object>(preContext);
        eqlRun.setExecutionContext(context);
        Pattern itemPattern = Pattern.compile("\\b" + this.item + "\\b");
        Pattern indexPattern = Pattern.compile("\\b" + this.index + "\\b");
        int i = -1;
        for (Object itemObj : items) {
            context.put(this.index, ++i);
            context.put(this.item, itemObj);
            String sql = this.part.evalSql(eqlRun);
            sql = this.processParams(PARAM_PATTERN, '#', itemPattern, indexPattern, i, sql);
            sql = this.processParams(DYNAMIC_PATTERN, '$', itemPattern, indexPattern, i, sql);
            if (i > 0 && S.isNotBlank(sql)) {
                str.append(this.separator);
            }
            str.append(sql);
        }
        str.append(this.close);
        eqlRun.setExecutionContext(preContext);
        return str.toString();
    }

    private String processParams(Pattern pattern, char ch, Pattern itemPattern, Pattern indexPattern, int idx, String sql) {
        Matcher matcher = pattern.matcher(sql);
        int startIndex = 0;
        StringBuilder str = new StringBuilder();
        while (matcher.find()) {
            str.append(sql.substring(startIndex, matcher.start()));
            startIndex = matcher.end();
            String expr = matcher.group(1);
            if (this.item.equals(expr)) {
                str.append(S.wrap(this.collection + "[" + idx + "]", ch));
                continue;
            }
            if (this.index.equals(expr)) {
                str.append(idx);
                continue;
            }
            String s = itemPattern.matcher(expr).replaceAll(this.collection + "[" + idx + "]");
            s = indexPattern.matcher(s).replaceAll("" + idx);
            str.append(S.wrap(S.escapeCrossAndDollar(s), ch));
        }
        if (startIndex < sql.length()) {
            str.append(sql.substring(startIndex));
        }
        return str.toString();
    }
}

