/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.List;
import java.util.regex.Matcher;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IsEmptyPart;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;

public class IsEmptyParser
implements PartParser {
    protected final String expr;
    protected MultiPart multiPart = new MultiPart();
    protected MultiPart elsePart = new MultiPart();

    public IsEmptyParser(String expr) {
        this.expr = expr;
    }

    @Override
    public EqlPart createPart() {
        return new IsEmptyPart(this.expr, this.multiPart, this.elsePart);
    }

    @Override
    public int parse(List<String> mergedLines, int index) {
        int i;
        LiteralPart lastPart = null;
        MultiPart current = this.multiPart;
        int ii = mergedLines.size();
        for (i = index; i < ii; ++i) {
            String clearLine;
            String line = mergedLines.get(i);
            if (line.startsWith("--")) {
                clearLine = ParserUtils.substr(line, "--".length());
            } else {
                Matcher matcher = ParserUtils.inlineComment.matcher(line);
                if (matcher.matches()) {
                    clearLine = matcher.group(1).trim();
                } else {
                    lastPart = new LiteralPart(line);
                    current.addPart(lastPart);
                    continue;
                }
            }
            if ("end".equalsIgnoreCase(clearLine)) {
                return i + 1;
            }
            if ("else".equalsIgnoreCase(clearLine)) {
                current = this.elsePart;
                continue;
            }
            PartParser partParser = PartParserFactory.tryParse(clearLine);
            if (partParser != null) {
                i = partParser.parse(mergedLines, i + 1) - 1;
                current.addPart(partParser.createPart());
                lastPart = null;
                continue;
            }
            if (!(lastPart instanceof LiteralPart)) continue;
            lastPart.appendComment(line);
        }
        return i;
    }
}

