/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import com.google.common.base.Objects;
import java.util.List;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IfCondition;

public class SwitchPart
implements EqlPart {
    private final String condition;
    private final List<IfCondition> cases;

    public SwitchPart(String condition, List<IfCondition> cases) {
        this.condition = condition;
        this.cases = cases;
    }

    public List<IfCondition> getCases() {
        return this.cases;
    }

    @Override
    public String evalSql(EqlRun eqlRun) {
        ExpressionEvaluator evaluator = eqlRun.getEqlConfig().getExpressionEvaluator();
        Object target = evaluator.eval(this.condition, eqlRun);
        if (target == null) {
            return "";
        }
        String strTarget = target.toString();
        for (IfCondition ifCondition : this.cases) {
            if (!"".equals(ifCondition.getExpr()) && !Objects.equal((Object)strTarget, (Object)ifCondition.getExpr())) continue;
            return ifCondition.getValue().evalSql(eqlRun);
        }
        return "";
    }
}

