/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql;

public class EqlPage {
    private int startIndex;
    private int pageRows;
    private int totalRows;

    public EqlPage() {
    }

    public EqlPage(int startIndex, int pageRows) {
        this.setStartIndex(startIndex);
        this.setPageRows(pageRows);
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(int startIndex) {
        this.startIndex = startIndex;
    }

    public int getPageRows() {
        return this.pageRows;
    }

    public void setPageRows(int pageRows) {
        this.pageRows = pageRows;
    }

    public int getTotalRows() {
        return this.totalRows;
    }

    public void setTotalRows(int totalRows) {
        this.totalRows = totalRows;
    }

    public int getCurrentPage() {
        return this.getPageRows() <= 0 ? 1 : (this.getStartIndex() + this.getPageRows()) / this.getPageRows();
    }

    public void setCurrentPage(int currentPage) {
        this.startIndex = this.getPageRows() <= 0 ? 0 : (currentPage - 1) * this.getPageRows();
    }

    public int getTotalPages() {
        int totalPages = this.getPageRows() <= 0 ? 1 : (this.getTotalRows() + this.getPageRows() - 1) / this.getPageRows();
        return totalPages < 1 ? 1 : totalPages;
    }

    public String toString() {
        return "EqlPage{startIndex=" + this.startIndex + ", pageRows=" + this.pageRows + ", totalRows=" + this.totalRows + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EqlPage eqlPage = (EqlPage)o;
        if (this.pageRows != eqlPage.pageRows) {
            return false;
        }
        return this.startIndex == eqlPage.startIndex;
    }

    public int hashCode() {
        int result = this.startIndex;
        result = 31 * result + this.pageRows;
        return result;
    }
}

