/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.cache;

import com.google.common.base.MoreObjects;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.ExecutionException;
import org.n3r.eql.cache.EqlCacheProvider;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.spec.ParamsAppliable;
import org.n3r.eql.spec.Spec;
import org.n3r.eql.spec.SpecParser;
import org.n3r.eql.util.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlCacheSettings {
    private static final Logger log = LoggerFactory.getLogger(EqlCacheSettings.class);
    public static final String DEFAULT_GUAVA_CACHE_MODEL = "guava";
    public static final String DEFAULT_DIAMOND_GUAVA_CACHE_MODEL = "diamond-guava";
    private static Cache<EqlCacheModelKey, EqlCacheProvider> eqlCacheModels = CacheBuilder.newBuilder().build();

    public static EqlCacheProvider processCacheModel(String sqlClassPath, KeyValue cacheModelSetting) {
        return EqlCacheSettings.processCacheModel(sqlClassPath, cacheModelSetting, true);
    }

    public static EqlCacheProvider processCacheModel(String sqlClassPath, KeyValue cacheModelSetting, boolean addToCache) {
        if (!cacheModelSetting.keyStartsWith("impl")) {
            return null;
        }
        KeyValue implKeyValue = cacheModelSetting.removeKeyPrefix("impl");
        String cacheModelName = implKeyValue.getKey();
        String cacheModelImpl = implKeyValue.getValue();
        Spec spec = SpecParser.parseSpecLeniently(cacheModelImpl);
        try {
            Class<?> clazz = Class.forName(spec.getName());
            if (!EqlCacheProvider.class.isAssignableFrom(clazz)) {
                log.error("processCacheModel {} required to implement org.n3r.eql.cache.EqlCacheProvider", (Object)spec.getName());
                return null;
            }
            EqlCacheProvider impl = (EqlCacheProvider)clazz.newInstance();
            if (impl instanceof ParamsAppliable) {
                ((ParamsAppliable)((Object)impl)).applyParams(spec.getParams());
            }
            if (addToCache) {
                eqlCacheModels.put((Object)new EqlCacheModelKey(sqlClassPath, cacheModelName), (Object)impl);
            }
            return impl;
        }
        catch (Exception e) {
            log.error("processCacheModel error", (Throwable)e);
            return null;
        }
    }

    public static EqlCacheProvider getCacheProvider(EqlUniqueSqlId uniqueSQLId, String cacheModel) {
        String model = (String)MoreObjects.firstNonNull((Object)cacheModel, (Object)DEFAULT_GUAVA_CACHE_MODEL);
        EqlCacheModelKey cacheModelKey = new EqlCacheModelKey(uniqueSQLId.getSqlClassPath(), model);
        EqlCacheProvider provider = (EqlCacheProvider)eqlCacheModels.getIfPresent((Object)cacheModelKey);
        if (provider != null) {
            return provider;
        }
        if (DEFAULT_GUAVA_CACHE_MODEL.equals(model)) {
            return EqlCacheSettings.createDefaultGuavaCacheModel(uniqueSQLId.getSqlClassPath(), cacheModelKey);
        }
        if (DEFAULT_DIAMOND_GUAVA_CACHE_MODEL.equals(model)) {
            return EqlCacheSettings.createDefaultDiamondGuavaCacheModel(uniqueSQLId.getSqlClassPath(), cacheModelKey);
        }
        log.warn("unable to find cache provider by cache model {}", (Object)model);
        return null;
    }

    private static EqlCacheProvider createDefaultGuavaCacheModel(String sqlClassPath, EqlCacheModelKey cacheModelKey) {
        String settingKey = "impl.guava";
        String settingVal = "@org.n3r.eql.cache.GuavaCacheProvider(\"expireAfterWrite=1d\")";
        KeyValue setting = new KeyValue("impl.guava", "@org.n3r.eql.cache.GuavaCacheProvider(\"expireAfterWrite=1d\")");
        return EqlCacheSettings.createCacheModel(sqlClassPath, cacheModelKey, setting);
    }

    private static EqlCacheProvider createDefaultDiamondGuavaCacheModel(String sqlClassPath, EqlCacheModelKey cacheModelKey) {
        String settingKey = "impl.diamond-guava";
        String settingVal = "@org.n3r.eql.cache.DiamondGuavaCacheProvider";
        KeyValue setting = new KeyValue("impl.diamond-guava", "@org.n3r.eql.cache.DiamondGuavaCacheProvider");
        return EqlCacheSettings.createCacheModel(sqlClassPath, cacheModelKey, setting);
    }

    private static EqlCacheProvider createCacheModel(String sqlClassPath, EqlCacheModelKey cacheModelKey, KeyValue setting) {
        try {
            return (EqlCacheProvider)eqlCacheModels.get((Object)cacheModelKey, () -> EqlCacheSettings.processCacheModel(sqlClassPath, setting, false));
        }
        catch (ExecutionException e) {
            log.warn("create default cache model error", e.getCause());
            return null;
        }
    }

    static final class EqlCacheModelKey {
        private final String sqlClassPath;
        private final String modelName;

        public EqlCacheModelKey(String sqlClassPath, String modelName) {
            this.sqlClassPath = sqlClassPath;
            this.modelName = modelName;
        }

        public String getSqlClassPath() {
            return this.sqlClassPath;
        }

        public String getModelName() {
            return this.modelName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof EqlCacheModelKey)) {
                return false;
            }
            EqlCacheModelKey other = (EqlCacheModelKey)o;
            String this$sqlClassPath = this.getSqlClassPath();
            String other$sqlClassPath = other.getSqlClassPath();
            if (this$sqlClassPath == null ? other$sqlClassPath != null : !this$sqlClassPath.equals(other$sqlClassPath)) {
                return false;
            }
            String this$modelName = this.getModelName();
            String other$modelName = other.getModelName();
            return !(this$modelName == null ? other$modelName != null : !this$modelName.equals(other$modelName));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sqlClassPath = this.getSqlClassPath();
            result = result * 59 + ($sqlClassPath == null ? 43 : $sqlClassPath.hashCode());
            String $modelName = this.getModelName();
            result = result * 59 + ($modelName == null ? 43 : $modelName.hashCode());
            return result;
        }

        public String toString() {
            return "EqlCacheSettings.EqlCacheModelKey(sqlClassPath=" + this.getSqlClassPath() + ", modelName=" + this.getModelName() + ")";
        }
    }
}

