/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.codedesc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import org.n3r.eql.codedesc.CodeDesc;
import org.n3r.eql.codedesc.CodeDescMapper;
import org.n3r.eql.codedesc.DecodeCodeDescMapper;
import org.n3r.eql.codedesc.MappingCodeDescMapper;
import org.n3r.eql.util.KeyValue;
import org.n3r.eql.util.S;

public class CodeDescSettings {
    static Cache<String, CodeDescMapper> codeDescCache = CacheBuilder.newBuilder().build();

    public static void processSetting(KeyValue codeDescSetting) {
        codeDescCache.put((Object)codeDescSetting.getKey(), (Object)CodeDescSettings.parseCodeDescMapper(codeDescSetting.getValue()));
    }

    private static CodeDescMapper parseCodeDescMapper(String mapperExpr) {
        String valueStr;
        int bracePos = mapperExpr.indexOf(40);
        String mapperAlias = bracePos < 0 ? mapperExpr : mapperExpr.substring(0, bracePos);
        String string = valueStr = bracePos < 0 ? "" : S.substrInQuotes(mapperExpr, '(', bracePos);
        if ("decode".equalsIgnoreCase(mapperAlias)) {
            return new DecodeCodeDescMapper(valueStr);
        }
        if ("mapping".equalsIgnoreCase(mapperAlias)) {
            return new MappingCodeDescMapper(valueStr);
        }
        return null;
    }

    public static String map(CodeDesc codeDesc, String code) {
        CodeDescMapper codeDescMapper = (CodeDescMapper)codeDescCache.getIfPresent((Object)codeDesc.getDescLabel());
        if (codeDescMapper != null) {
            return codeDescMapper.map(code);
        }
        return null;
    }
}

