/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.codedesc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.codedesc.CodeDesc;
import org.n3r.eql.codedesc.CodeDescCache;
import org.n3r.eql.codedesc.CodeDescResultSetHandler;
import org.n3r.eql.codedesc.CodeDescSettings;
import org.n3r.eql.codedesc.DefaultCodeDescMapper;
import org.n3r.eql.codedesc.DescOptionValueParser;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.ex.EqlConfigException;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.OffsetAndOptionValue;
import org.n3r.eql.spec.Spec;
import org.n3r.eql.spec.SpecParser;
import org.n3r.eql.util.Rs;
import org.n3r.eql.util.S;

public class CodeDescs {
    public static ResultSet codeDescWrap(EqlRun currEqlRun, EqlBlock eqlBlock, EqlConfigDecorator eqlConfig, String sqlClassPath, ResultSet rs, String tagSqlId) {
        List<CodeDesc> descs = eqlBlock.getCodeDescs();
        if (descs == null) {
            return rs;
        }
        if (!CodeDescs.existsReturnDescColumns(descs, rs)) {
            return rs;
        }
        return new CodeDescResultSetHandler(currEqlRun, eqlConfig, sqlClassPath, rs, descs, tagSqlId).createProxy();
    }

    private static boolean existsReturnDescColumns(List<CodeDesc> descs, ResultSet rs) {
        ResultSetMetaData metaData = rs.getMetaData();
        int ii = metaData.getColumnCount();
        for (int i = 0; i < ii; ++i) {
            String columnName = Rs.lookupColumnName(metaData, i + 1);
            for (CodeDesc codeDesc : descs) {
                if (!codeDesc.getColumnName().equals(columnName)) continue;
                return true;
            }
        }
        return false;
    }

    public static List<CodeDesc> parseOption(EqlBlock eqlBlock, String desc) {
        OffsetAndOptionValue oo;
        if (S.isBlank(desc)) {
            return null;
        }
        ArrayList<CodeDesc> codeDescs = new ArrayList<CodeDesc>();
        DescOptionValueParser descOptionValueParser = new DescOptionValueParser();
        int size = desc.length();
        for (int pos = 0; pos < size && (oo = descOptionValueParser.parseValueOption(desc.substring(pos))) != null; pos += oo.getOffset()) {
            CodeDesc codeDesc = CodeDescs.parseCodeDesc(eqlBlock, oo.getOptionValue());
            codeDescs.add(codeDesc);
        }
        return codeDescs.size() == 0 ? null : codeDescs;
    }

    private static CodeDesc parseCodeDesc(EqlBlock eqlBlock, String descPart) {
        int atPos = descPart.indexOf(64);
        CodeDescs.check(eqlBlock, atPos > 0);
        String columnName = descPart.substring(0, atPos);
        String reference = descPart.substring(atPos);
        Spec spec = SpecParser.parseSpec(reference);
        return new CodeDesc(columnName, spec);
    }

    private static void check(EqlBlock eqlBlock, boolean expr) {
        if (expr) {
            return;
        }
        throw new EqlConfigException(eqlBlock.getUniqueSqlIdStr() + "'s desc format is invalid");
    }

    public static String map(EqlRun currEqlRun, EqlConfigDecorator eqlConfig, String sqlClassPath, CodeDesc codeDesc, String code, String tagSqlId) {
        String desc = CodeDescSettings.map(codeDesc, code);
        if (desc != null) {
            return desc;
        }
        EqlBlock eqlBlock = CodeDescs.findEqlBlock(eqlConfig, sqlClassPath, codeDesc);
        if (eqlBlock == null) {
            return null;
        }
        DefaultCodeDescMapper mapper = CodeDescCache.getCachedMapper(sqlClassPath, codeDesc, currEqlRun, eqlConfig, eqlBlock, tagSqlId);
        return mapper == null ? null : mapper.map(code);
    }

    private static EqlBlock findEqlBlock(EqlConfigDecorator eqlConfig, String sqlClassPath, CodeDesc codeDesc) {
        try {
            EqlResourceLoader sqlResourceLoader = eqlConfig.getSqlResourceLoader();
            return sqlResourceLoader.loadEqlBlock(sqlClassPath, codeDesc.getDescLabel());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

