/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.config;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.ex.EqlConfigException;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.trans.EqlConnection;
import org.n3r.eql.trans.EqlJndiConnection;
import org.n3r.eql.trans.EqlSimpleConnection;
import org.n3r.eql.trans.EqlTranFactory;
import org.n3r.eql.util.S;

public class EqlConfigManager {
    private static LoadingCache<EqlConfigDecorator, EqlTranFactory> eqlTranFactoryCache = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).removalListener(notification -> {
        ((EqlConfigDecorator)notification.getKey()).onRemoval();
        try {
            ((EqlTranFactory)notification.getValue()).destory();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }).build((CacheLoader)new CacheLoader<EqlConfigDecorator, EqlTranFactory>(){

        public EqlTranFactory load(EqlConfigDecorator eqlConfig) {
            eqlConfig.onLoad();
            return EqlConfigManager.createEqlTranFactory(eqlConfig);
        }
    });

    private static EqlTranFactory createEqlTranFactory(EqlConfig eqlConfig) {
        EqlConnection eqlConn = EqlConfigManager.createEqlConnection(eqlConfig, "connection.impl");
        eqlConn.initialize(eqlConfig);
        String tranType = eqlConfig.getStr("transactionType");
        return new EqlTranFactory(eqlConn, "JTA".equalsIgnoreCase(tranType));
    }

    public static EqlConnection createEqlConnection(EqlConfig eqlConfig, String implKey) {
        String eqlConfigClass = eqlConfig.getStr(implKey);
        if (S.isBlank(eqlConfigClass)) {
            String jndiName = eqlConfig.getStr("jndiName");
            return S.isBlank(jndiName) ? new EqlSimpleConnection() : new EqlJndiConnection();
        }
        return (EqlConnection)Reflect.on(eqlConfigClass).create().get();
    }

    public static EqlTranFactory getConfig(EqlConfigDecorator eqlConfig) {
        try {
            return (EqlTranFactory)eqlTranFactoryCache.get((Object)eqlConfig);
        }
        catch (ExecutionException e) {
            throw new EqlConfigException("EqlConfig " + eqlConfig + " is not properly configured.", e.getCause());
        }
    }

    public static void invalidateCache(EqlConfigDecorator eqlConfig) {
        eqlTranFactoryCache.invalidate((Object)eqlConfig);
    }
}

