/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.parser;

import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.dialect.mysql.parser.MySqlStatementParser;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitorAdapter;
import java.util.Set;
import java.util.regex.Matcher;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSensitiveFieldsParser
extends SensitiveFieldsParser {
    private static final Logger log = LoggerFactory.getLogger(MySqlSensitiveFieldsParser.class);
    private SQLASTVisitorAdapter adapter = new MySqlASTVisitorAdapter(){

        public boolean visit(SQLVariantRefExpr x) {
            return MySqlSensitiveFieldsParser.this.adapter_impl.visit(x);
        }

        public boolean visit(SQLBinaryOpExpr x) {
            return MySqlSensitiveFieldsParser.this.adapter_impl.visit(x);
        }
    };

    public MySqlSensitiveFieldsParser(Set<String> secureFields, String sql) {
        super(secureFields, sql);
    }

    @Override
    protected SQLASTVisitorAdapter getAdapter() {
        return this.adapter;
    }

    @Override
    protected SQLASTVisitor createSQLVariantVisitor(final SQLASTVisitorAdapter visitor) {
        return new MySqlASTVisitorAdapter(){

            public boolean visit(SQLVariantRefExpr x) {
                return visitor.visit(x);
            }
        };
    }

    private static SensitiveFieldsParser tryParseHint(String sql, Set<String> secureFields) {
        Matcher matcher = encryptHint.matcher(sql);
        if (matcher.find() && matcher.start() == 0) {
            String convertedSql = sql.substring(matcher.end());
            String hint = matcher.group(1);
            MySqlSensitiveFieldsParser fieldsParser = new MySqlSensitiveFieldsParser(secureFields, convertedSql);
            fieldsParser.parseHint(hint);
            return fieldsParser;
        }
        return null;
    }

    private static SQLStatement parseSql(String sql) {
        MySqlStatementParser parser = new MySqlStatementParser(sql);
        try {
            return parser.parseStatement();
        }
        catch (ParserException exception) {
            exception.printStackTrace();
            throw new RuntimeException(sql + " is invalid, detail " + exception.getMessage());
        }
    }

    public static SensitiveFieldsParser parseSql(String sql, Set<String> secureFields) {
        SensitiveFieldsParser fieldsParser = MySqlSensitiveFieldsParser.tryParseHint(sql, secureFields);
        if (fieldsParser == null) {
            SQLStatement sqlStatement = MySqlSensitiveFieldsParser.parseSql(sql);
            MySqlSensitiveFieldsParser sensitiveFieldsParser = new MySqlSensitiveFieldsParser(secureFields, sql);
            fieldsParser = SensitiveFieldsParser.parseStatement(sensitiveFieldsParser, sqlStatement);
        }
        if (fieldsParser == null) {
            return null;
        }
        if (fieldsParser.haveNonSecureFields()) {
            return null;
        }
        return fieldsParser;
    }
}

