/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.dbfieldcryptor.parser;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Set;
import org.n3r.eql.DbDialect;
import org.n3r.eql.dbfieldcryptor.parser.MySqlSensitiveFieldsParser;
import org.n3r.eql.dbfieldcryptor.parser.OracleSensitiveFieldsParser;
import org.n3r.eql.dbfieldcryptor.parser.SensitiveFieldsParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserCache {
    private static final Logger log = LoggerFactory.getLogger(ParserCache.class);
    final Set<String> secureFieldsConfig;
    final LoadingCache<DbIdSql, Optional<SensitiveFieldsParser>> cache;

    public ParserCache(Set<String> secureFieldsConfig) {
        this.secureFieldsConfig = secureFieldsConfig;
        this.cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<DbIdSql, Optional<SensitiveFieldsParser>>(){

            public Optional<SensitiveFieldsParser> load(DbIdSql dbIdSql) {
                return Optional.fromNullable((Object)ParserCache.this.getParser(dbIdSql));
            }
        });
    }

    private SensitiveFieldsParser getParser(DbIdSql dbIdSql) {
        String databaseId = dbIdSql.getDatabaseId();
        String sql = dbIdSql.getSql();
        try {
            SensitiveFieldsParser parser = this.getSensitiveFieldsParser(databaseId, sql);
            if (parser == null) {
                return null;
            }
            if (parser.haveNonSecureFields()) {
                return null;
            }
            return parser;
        }
        catch (Exception ex) {
            log.warn("parse sql [{}] failed {}", (Object)sql, (Object)ex.getMessage());
            return null;
        }
    }

    private SensitiveFieldsParser getSensitiveFieldsParser(String dbId, String sql) {
        if ("oracle".equals(dbId)) {
            return OracleSensitiveFieldsParser.parseSql(sql, this.secureFieldsConfig);
        }
        if ("mysql".equals(dbId)) {
            return MySqlSensitiveFieldsParser.parseSql(sql, this.secureFieldsConfig);
        }
        return null;
    }

    public SensitiveFieldsParser getParser(DbDialect dbDialect, String sql) {
        return (SensitiveFieldsParser)((Optional)this.cache.getUnchecked((Object)new DbIdSql(dbDialect.getDatabaseId(), sql))).orNull();
    }

    static class DbIdSql {
        final String databaseId;
        final String sql;

        public String getDatabaseId() {
            return this.databaseId;
        }

        public String getSql() {
            return this.sql;
        }

        public DbIdSql(String databaseId, String sql) {
            this.databaseId = databaseId;
            this.sql = sql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DbIdSql)) {
                return false;
            }
            DbIdSql other = (DbIdSql)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$databaseId = this.getDatabaseId();
            String other$databaseId = other.getDatabaseId();
            if (this$databaseId == null ? other$databaseId != null : !this$databaseId.equals(other$databaseId)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DbIdSql;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $databaseId = this.getDatabaseId();
            result = result * 59 + ($databaseId == null ? 43 : $databaseId.hashCode());
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            return result;
        }
    }
}

