/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.n3r.eql.eqler.enhancer.EqlerEnhancer;
import org.n3r.eql.eqler.generators.ClassGenerator;
import org.n3r.eql.ex.EqlConfigException;

public final class EqlerFactory {
    private static List<EqlerEnhancer> enhancers = StreamSupport.stream(ServiceLoader.load(EqlerEnhancer.class).spliterator(), false).sorted(Comparator.comparingInt(EqlerEnhancer::getOrder).reversed()).collect(Collectors.toList());
    private static Cache<Class, Object> eqlerCache = CacheBuilder.newBuilder().build();

    public static <T> T getEqler(Class<T> eqlerClass) {
        EqlerFactory.ensureClassIsAnInterface(eqlerClass);
        return (T)eqlerCache.get(eqlerClass, () -> EqlerFactory.loadEqler(eqlerClass));
    }

    private static Object loadEqler(Class eqlerClass) {
        ClassGenerator generator = new ClassGenerator(eqlerClass);
        Class eqlImplClass = generator.generate();
        Object implObjet = EqlerFactory.createObject(eqlImplClass);
        return EqlerFactory.wrapWithEnhancer(eqlerClass, implObjet);
    }

    private static Object wrapWithEnhancer(Class eqlerClass, Object implObject) {
        Object enhancedObject = implObject;
        for (EqlerEnhancer enhancer : enhancers) {
            if (!enhancer.isEnabled(eqlerClass)) continue;
            enhancedObject = enhancer.build(eqlerClass, enhancedObject);
        }
        return enhancedObject;
    }

    private static <T> T createObject(Class<T> clazz) {
        return clazz.newInstance();
    }

    private static <T> void ensureClassIsAnInterface(Class<T> clazz) {
        if (clazz.isInterface()) {
            return;
        }
        throw new EqlConfigException(clazz + " is not an interface");
    }

    private EqlerFactory() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

