/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler.generators;

import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.EqlPage;
import org.n3r.eql.EqlTran;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.eqler.annotations.Dynamic;
import org.n3r.eql.eqler.annotations.Param;
import org.n3r.eql.eqler.annotations.ReturnType;
import org.n3r.eql.eqler.annotations.SqlId;
import org.n3r.eql.eqler.generators.MethodParam;
import org.n3r.eql.impl.EqlBatch;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.pojo.annotations.EqlId;
import org.objectweb.asm.Type;

public class MethodAllParam {
    private List<MethodParam> methodParams = Lists.newArrayList();
    private int seqParamsCount;
    private int seqDynamicsCount;
    private int namedParamsCount;
    private int namedDynamicCount;
    private MethodParam paramEqlId;
    private MethodParam paramReturnType;
    private MethodParam eqlTran;
    private MethodParam eqlBatch;
    private MethodParam eqlPage;
    private MethodParam eqlConfig;
    private MethodParam eqlRowMapper;
    private int methodParamsCount = 0;
    private int asmLocalVarNamedParamIndex = -1;
    int asmLocalVarNamedDynamicIndex = -1;
    private EqlId methodEqlId;

    public void compute() {
        int offset = 0;
        for (MethodParam methodParam : this.methodParams) {
            this.computeMethodParam(methodParam);
            methodParam.setOffset(offset);
            if (!this.isWildType(methodParam)) continue;
            ++offset;
        }
        if (this.seqParamsCount > 0 && this.namedParamsCount > 0) {
            throw new RuntimeException("@Param should be used to annotate parameters all or none");
        }
        if (this.seqDynamicsCount > 0 && this.namedDynamicCount > 0) {
            throw new RuntimeException("@Dynamic(name=\"sth.\" should be used to annotate dynamics all or none");
        }
        if (this.namedParamsCount > 0) {
            this.asmLocalVarNamedParamIndex = 1 + this.methodParamsCount + 1;
        }
        if (this.namedDynamicCount > 0) {
            this.asmLocalVarNamedDynamicIndex = 1 + this.methodParamsCount + (this.namedParamsCount > 0 ? 2 : 1);
        }
    }

    private boolean isWildType(MethodParam methodParam) {
        Type tp = Type.getType(methodParam.getParamType());
        return tp.equals((Object)Type.LONG_TYPE) || tp.equals((Object)Type.DOUBLE_TYPE);
    }

    private void computeMethodParam(MethodParam methodParam) {
        Dynamic dynamic;
        MethodParam eqlTranNew = this.parseNonAnnotationsMethodParam(methodParam, EqlTran.class, this.eqlTran);
        if (eqlTranNew != null) {
            this.eqlTran = eqlTranNew;
            return;
        }
        MethodParam eqlBatchNew = this.parseNonAnnotationsMethodParam(methodParam, EqlBatch.class, this.eqlBatch);
        if (eqlBatchNew != null) {
            this.eqlBatch = eqlBatchNew;
            return;
        }
        MethodParam eqlPageNew = this.parseNonAnnotationsMethodParam(methodParam, EqlPage.class, this.eqlPage);
        if (eqlPageNew != null) {
            this.eqlPage = eqlPageNew;
            return;
        }
        MethodParam eqlConfigNew = this.parseNonAnnotationsMethodParam(methodParam, EqlConfig.class, this.eqlConfig);
        if (eqlConfigNew != null) {
            this.eqlConfig = eqlConfigNew;
            return;
        }
        MethodParam eqlRowMapperNew = this.parseNonAnnotationsMethodParam(methodParam, EqlRowMapper.class, this.eqlRowMapper);
        if (eqlRowMapperNew != null) {
            this.eqlRowMapper = eqlRowMapperNew;
            return;
        }
        if (this.isSqlIdAnnotated(methodParam)) {
            return;
        }
        if (this.isReturnTypeAnnotated(methodParam)) {
            return;
        }
        ++this.methodParamsCount;
        Param param = methodParam.getParam();
        if (param != null) {
            methodParam.setSeqParamIndex(this.namedParamsCount++);
        }
        if ((dynamic = methodParam.getDynamic()) == null) {
            if (param == null) {
                methodParam.setSeqParamIndex(this.seqParamsCount++);
            }
        } else {
            if (dynamic.sole() && param != null) {
                throw new RuntimeException("@DynamicParam(sole=true) and @NamedParam can not co-exists");
            }
            if (StringUtils.isBlank((CharSequence)dynamic.value()) && StringUtils.isBlank((CharSequence)dynamic.name())) {
                methodParam.setSeqDynamicIndex(this.seqDynamicsCount++);
            } else {
                methodParam.setSeqDynamicIndex(this.namedDynamicCount++);
            }
            if (!dynamic.sole() && param == null) {
                methodParam.setSeqParamIndex(this.seqParamsCount++);
            }
        }
    }

    private boolean isReturnTypeAnnotated(MethodParam methodParam) {
        ReturnType returnType = methodParam.getReturnType();
        if (returnType == null) {
            return false;
        }
        if (this.paramReturnType != null) {
            throw new RuntimeException("more than one @ReturnType defined");
        }
        if (methodParam.getParamType() != Class.class) {
            throw new RuntimeException("bad @ReturnType parameter type, required Class");
        }
        this.paramReturnType = methodParam;
        return true;
    }

    private boolean isSqlIdAnnotated(MethodParam methodParam) {
        SqlId paramEqlIdThis = methodParam.getSqlId();
        if (paramEqlIdThis == null) {
            return false;
        }
        if (this.methodEqlId != null || this.paramEqlId != null) {
            throw new RuntimeException("more than one @EqlId defined");
        }
        if (methodParam.getParamType() != String.class) {
            throw new RuntimeException("bad @EqlId parameter type, required String");
        }
        this.paramEqlId = methodParam;
        return true;
    }

    private MethodParam parseNonAnnotationsMethodParam(MethodParam methodParam, Class<?> type, MethodParam lastMethodParam) {
        if (type.isAssignableFrom(methodParam.getParamType())) {
            this.checkNull(lastMethodParam, "only one " + type + " parameter supported");
            this.checkNonAnnotations(methodParam);
            return methodParam;
        }
        return null;
    }

    private void checkNonAnnotations(MethodParam methodParam) {
        Annotation[] paramAnnotations = methodParam.getParamAnnotations();
        if (paramAnnotations.length == 0) {
            return;
        }
        throw new RuntimeException("Annotations are not supported for type " + methodParam.getParamType());
    }

    private void checkNull(Object object, String msg) {
        if (object == null) {
            return;
        }
        throw new RuntimeException(msg);
    }

    public void addMethodParam(MethodParam methodParam) {
        this.methodParams.add(methodParam);
    }

    public MethodParam getMethodParam(int index) {
        return this.methodParams.get(index);
    }

    public int getParamsSize() {
        return this.methodParams.size();
    }

    public int getSeqParamsCount() {
        return this.seqParamsCount;
    }

    public int getSeqDynamicsCount() {
        return this.seqDynamicsCount;
    }

    public int getNamedParamsCount() {
        return this.namedParamsCount;
    }

    public int getNamedDynamicCount() {
        return this.namedDynamicCount;
    }

    public MethodParam getParamEqlId() {
        return this.paramEqlId;
    }

    public MethodParam getParamReturnType() {
        return this.paramReturnType;
    }

    public MethodParam getEqlTran() {
        return this.eqlTran;
    }

    public MethodParam getEqlBatch() {
        return this.eqlBatch;
    }

    public MethodParam getEqlPage() {
        return this.eqlPage;
    }

    public MethodParam getEqlConfig() {
        return this.eqlConfig;
    }

    public MethodParam getEqlRowMapper() {
        return this.eqlRowMapper;
    }

    public int getMethodParamsCount() {
        return this.methodParamsCount;
    }

    public int getAsmLocalVarNamedParamIndex() {
        return this.asmLocalVarNamedParamIndex;
    }

    public int getAsmLocalVarNamedDynamicIndex() {
        return this.asmLocalVarNamedDynamicIndex;
    }

    public void setMethodEqlId(EqlId methodEqlId) {
        this.methodEqlId = methodEqlId;
    }
}

