/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler.generators;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.Eql;
import org.n3r.eql.EqlPage;
import org.n3r.eql.EqlTran;
import org.n3r.eql.EqlTranable;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.eqler.OnErr;
import org.n3r.eql.eqler.annotations.Dynamic;
import org.n3r.eql.eqler.annotations.EqlMapper;
import org.n3r.eql.eqler.annotations.EqlerConfig;
import org.n3r.eql.eqler.annotations.Param;
import org.n3r.eql.eqler.annotations.ProfiledSql;
import org.n3r.eql.eqler.annotations.ProfiledSqls;
import org.n3r.eql.eqler.annotations.Sql;
import org.n3r.eql.eqler.annotations.SqlId;
import org.n3r.eql.eqler.annotations.SqlOptions;
import org.n3r.eql.eqler.annotations.UseSqlFile;
import org.n3r.eql.eqler.generators.ActiveProfilesThreadLocal;
import org.n3r.eql.eqler.generators.Generatable;
import org.n3r.eql.eqler.generators.MethodAllParam;
import org.n3r.eql.eqler.generators.MethodParam;
import org.n3r.eql.impl.EqlBatch;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.pojo.annotations.EqlId;
import org.n3r.eql.trans.EqlTranThreadLocal;
import org.n3r.eql.util.Asms;
import org.n3r.eql.util.S;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public class MethodGenerator<T>
implements Generatable {
    public static final String EQL = Asms.p(Eql.class);
    private final Method method;
    private final MethodVisitor mv;
    private final Class<T> eqlerClass;
    private final EqlerConfig eqlerConfig;
    private final UseSqlFile classUseSqlFile;
    private final String eqlClassName;
    private final MethodAllParam methodAllParam;

    public MethodGenerator(ClassWriter classWriter, Method method, Class<T> eqlerClass) {
        this.method = method;
        this.eqlerClass = eqlerClass;
        EqlerConfig methodEqlerConfig = Generatable.parseEqlerConfig(method);
        EqlerConfig classEqlerConfig = Generatable.parseEqlerConfig(eqlerClass);
        this.eqlerConfig = methodEqlerConfig != null ? methodEqlerConfig : classEqlerConfig;
        this.eqlClassName = this.eqlerConfig != null ? org.objectweb.asm.Type.getInternalName(this.eqlerConfig.eql()) : EQL;
        this.classUseSqlFile = eqlerClass.getAnnotation(UseSqlFile.class);
        this.mv = classWriter.visitMethod(1, method.getName(), org.objectweb.asm.Type.getMethodDescriptor((Method)method), null, null);
        this.methodAllParam = this.parseParams(method);
    }

    @Override
    public void generate() {
        this.start();
        this.prepareNamedParams();
        this.prepareNamedDynamics();
        String[] sqls = this.parseSqls(this.method);
        this.newEql();
        this.useTran();
        this.useBatch();
        this.useSqlFile();
        this.params();
        this.dynamics();
        this.id(sqls);
        this.returnType();
        this.limit();
        this.options();
        this.execute(sqls);
        this.result();
        this.end();
    }

    private void useBatch() {
        MethodParam eqlBatch = this.methodAllParam.getEqlBatch();
        if (eqlBatch == null) {
            return;
        }
        this.mv.visitVarInsn(25, eqlBatch.getParamIndex() + 1);
        this.mv.visitMethodInsn(182, EQL, "useBatch", Asms.sig(Eql.class, EqlBatch.class), false);
    }

    private void useTran() {
        MethodParam eqlTran = this.methodAllParam.getEqlTran();
        if (eqlTran != null) {
            this.mv.visitVarInsn(25, eqlTran.getParamIndex() + 1);
            this.mv.visitMethodInsn(182, EQL, "useTran", Asms.sig(Eql.class, EqlTran.class), false);
        } else if (EqlTranable.class.isAssignableFrom(this.eqlerClass)) {
            this.mv.visitMethodInsn(184, Asms.p(EqlTranThreadLocal.class), "get", Asms.sig(EqlTran.class, new Class[0]), false);
            this.mv.visitMethodInsn(182, EQL, "useTran", Asms.sig(Eql.class, EqlTran.class), false);
        }
    }

    private void prepareNamedParams() {
        if (this.methodAllParam.getNamedParamsCount() == 0) {
            return;
        }
        this.mv.visitMethodInsn(184, Asms.p(Maps.class), "newHashMap", Asms.sig(HashMap.class, new Class[0]), false);
        this.mv.visitVarInsn(58, this.methodAllParam.getAsmLocalVarNamedParamIndex());
        for (int i = 0; i < this.methodAllParam.getMethodParamsCount(); ++i) {
            MethodParam methodParam = this.methodAllParam.getMethodParam(i);
            Param param = methodParam.getParam();
            if (param == null) continue;
            this.mv.visitVarInsn(25, this.methodAllParam.getAsmLocalVarNamedParamIndex());
            this.mv.visitLdcInsn((Object)param.value());
            this.visitVar(i + 1 + methodParam.getOffset(), org.objectweb.asm.Type.getType(methodParam.getParamType()));
            this.mv.visitMethodInsn(185, Asms.p(Map.class), "put", Asms.sig(Object.class, Object.class, Object.class), true);
            this.mv.visitInsn(87);
        }
    }

    private void prepareNamedDynamics() {
        if (this.methodAllParam.getNamedDynamicCount() == 0) {
            return;
        }
        this.mv.visitMethodInsn(184, Asms.p(Maps.class), "newHashMap", Asms.sig(HashMap.class, new Class[0]), false);
        this.mv.visitVarInsn(58, this.methodAllParam.getAsmLocalVarNamedDynamicIndex());
        for (int i = 0; i < this.methodAllParam.getMethodParamsCount(); ++i) {
            MethodParam methodParam = this.methodAllParam.getMethodParam(i);
            Dynamic dynamic = methodParam.getDynamic();
            if (dynamic == null || StringUtils.isBlank((CharSequence)dynamic.value()) && StringUtils.isBlank((CharSequence)dynamic.name())) continue;
            this.mv.visitVarInsn(25, this.methodAllParam.getAsmLocalVarNamedDynamicIndex());
            this.mv.visitLdcInsn((Object)(StringUtils.isBlank((CharSequence)dynamic.value()) ? dynamic.name() : dynamic.value()));
            this.visitVar(i + 1 + methodParam.getOffset(), org.objectweb.asm.Type.getType(methodParam.getParamType()));
            this.mv.visitMethodInsn(185, Asms.p(Map.class), "put", Asms.sig(Object.class, Object.class, Object.class), true);
            this.mv.visitInsn(87);
        }
    }

    private void visitVar(int i, org.objectweb.asm.Type tp) {
        if (tp.equals((Object)org.objectweb.asm.Type.BOOLEAN_TYPE)) {
            this.mv.visitVarInsn(21, i);
            this.mv.visitMethodInsn(184, Asms.p(Boolean.class), "valueOf", "(Z)Ljava/lang/Boolean;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.BYTE_TYPE)) {
            this.mv.visitVarInsn(21, i);
            this.mv.visitMethodInsn(184, Asms.p(Byte.class), "valueOf", "(B)Ljava/lang/Byte;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.CHAR_TYPE)) {
            this.mv.visitVarInsn(21, i);
            this.mv.visitMethodInsn(184, Asms.p(Character.class), "valueOf", "(C)Ljava/lang/Character;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.SHORT_TYPE)) {
            this.mv.visitVarInsn(21, i);
            this.mv.visitMethodInsn(184, Asms.p(Short.class), "valueOf", "(S)Ljava/lang/Short;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.INT_TYPE)) {
            this.mv.visitVarInsn(21, i);
            this.mv.visitMethodInsn(184, Asms.p(Integer.class), "valueOf", "(I)Ljava/lang/Integer;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.LONG_TYPE)) {
            this.mv.visitVarInsn(22, i);
            this.mv.visitMethodInsn(184, Asms.p(Long.class), "valueOf", "(J)Ljava/lang/Long;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.FLOAT_TYPE)) {
            this.mv.visitVarInsn(23, i);
            this.mv.visitMethodInsn(184, Asms.p(Float.class), "valueOf", "(F)Ljava/lang/Float;", false);
        } else if (tp.equals((Object)org.objectweb.asm.Type.DOUBLE_TYPE)) {
            this.mv.visitVarInsn(24, i);
            this.mv.visitMethodInsn(184, Asms.p(Double.class), "valueOf", "(D)Ljava/lang/Double;", false);
        } else {
            this.mv.visitVarInsn(25, i);
        }
    }

    private void start() {
        this.mv.visitCode();
    }

    private void end() {
        this.mv.visitMaxs(-1, -1);
        this.mv.visitEnd();
    }

    private void newEql() {
        this.mv.visitTypeInsn(187, this.eqlClassName);
        this.mv.visitInsn(89);
        MethodParam eqlConfig = this.methodAllParam.getEqlConfig();
        if (eqlConfig == null) {
            this.mv.visitLdcInsn((Object)(this.eqlerConfig != null ? this.eqlerConfig.value() : "DEFAULT"));
            this.mv.visitMethodInsn(183, this.eqlClassName, "<init>", Asms.sig(Void.TYPE, String.class), false);
        } else {
            this.mv.visitVarInsn(25, eqlConfig.getParamIndex() + 1);
            this.mv.visitMethodInsn(183, this.eqlClassName, "<init>", Asms.sig(Void.TYPE, EqlConfig.class), false);
        }
        this.mv.visitMethodInsn(182, this.eqlClassName, "me", Asms.sig(Eql.class, new Class[0]), false);
    }

    private void result() {
        Class<?> returnType = this.method.getReturnType();
        org.objectweb.asm.Type tp = org.objectweb.asm.Type.getType(returnType);
        if (tp.equals((Object)org.objectweb.asm.Type.BOOLEAN_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Boolean");
            this.mv.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z", false);
            this.mv.visitInsn(172);
        } else if (tp.equals((Object)org.objectweb.asm.Type.BYTE_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Byte");
            this.mv.visitMethodInsn(182, "java/lang/Byte", "byteValue", "()B", false);
            this.mv.visitInsn(172);
        } else if (tp.equals((Object)org.objectweb.asm.Type.CHAR_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Character");
            this.mv.visitMethodInsn(182, "java/lang/Character", "charValue", "()C", false);
            this.mv.visitInsn(172);
        } else if (tp.equals((Object)org.objectweb.asm.Type.SHORT_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Short");
            this.mv.visitMethodInsn(182, "java/lang/Short", "shortValue", "()S", false);
            this.mv.visitInsn(172);
        } else if (tp.equals((Object)org.objectweb.asm.Type.INT_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Integer");
            this.mv.visitMethodInsn(182, "java/lang/Integer", "intValue", "()I", false);
            this.mv.visitInsn(172);
        } else if (tp.equals((Object)org.objectweb.asm.Type.LONG_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Long");
            this.mv.visitMethodInsn(182, "java/lang/Long", "longValue", "()J", false);
            this.mv.visitInsn(173);
        } else if (tp.equals((Object)org.objectweb.asm.Type.FLOAT_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Float");
            this.mv.visitMethodInsn(182, "java/lang/Float", "floatValue", "()F", false);
            this.mv.visitInsn(174);
        } else if (tp.equals((Object)org.objectweb.asm.Type.DOUBLE_TYPE)) {
            this.mv.visitTypeInsn(192, "java/lang/Double");
            this.mv.visitMethodInsn(182, "java/lang/Double", "doubleValue", "()D", false);
            this.mv.visitInsn(175);
        } else if (tp.equals((Object)org.objectweb.asm.Type.VOID_TYPE)) {
            this.mv.visitInsn(87);
            this.mv.visitInsn(177);
        } else {
            this.mv.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(returnType));
            this.mv.visitInsn(176);
        }
    }

    private void options() {
        SqlOptions sqlOptions = this.method.getAnnotation(SqlOptions.class);
        if (sqlOptions == null) {
            return;
        }
        this.mv.visitLdcInsn((Object)this.createOptions(sqlOptions));
        this.mv.visitMethodInsn(182, EQL, "options", Asms.sig(Eql.class, String.class), false);
    }

    private String createOptions(SqlOptions sqlOptions) {
        String split;
        StringBuilder optionsStr = new StringBuilder();
        if (sqlOptions.iterate()) {
            optionsStr.append(" iterate ");
        }
        if (sqlOptions.onErr() == OnErr.Resume) {
            optionsStr.append(" onerr=resume ");
        }
        if (S.isNotEmpty(split = sqlOptions.split())) {
            optionsStr.append(" split=").append(split);
        }
        optionsStr.append(' ').append(sqlOptions.value());
        return optionsStr.toString();
    }

    private void execute(String[] sqls) {
        if (sqls.length == 0) {
            this.mv.visitInsn(3);
            this.mv.visitTypeInsn(189, "java/lang/String");
        } else {
            this.mv.visitInsn(3 + sqls.length);
            this.mv.visitTypeInsn(189, "java/lang/String");
            for (int i = 0; i < sqls.length; ++i) {
                this.mv.visitInsn(89);
                this.visitIntInsn(i);
                this.mv.visitLdcInsn((Object)sqls[i]);
                this.mv.visitInsn(83);
            }
        }
        this.mv.visitMethodInsn(182, EQL, "execute", Asms.sig(Object.class, String[].class), false);
    }

    private String[] parseSqls(Method method) {
        ArrayList sqls = Lists.newArrayList();
        Set<String> activeProfiles = this.parseActiveProfiles();
        for (Annotation annotation : method.getAnnotations()) {
            if (annotation instanceof Sql) {
                for (String sql : ((Sql)annotation).value()) {
                    sqls.add(sql);
                }
                continue;
            }
            if (annotation instanceof ProfiledSql) {
                this.addProfiledSqls(activeProfiles, sqls, (ProfiledSql)annotation);
                continue;
            }
            if (!(annotation instanceof ProfiledSqls)) continue;
            for (ProfiledSql profileSql : ((ProfiledSqls)annotation).value()) {
                this.addProfiledSqls(activeProfiles, sqls, profileSql);
            }
        }
        return sqls.toArray(new String[sqls.size()]);
    }

    private Set<String> parseActiveProfiles() {
        Object[] activeProfiles = ActiveProfilesThreadLocal.get();
        if (activeProfiles == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Object[])activeProfiles);
    }

    private void addProfiledSqls(Set<String> activeProfiles, List<String> sqls, ProfiledSql profiledSql) {
        if (this.containsInActiveProfiles(activeProfiles, profiledSql.profile())) {
            for (String sql : profiledSql.sql()) {
                sqls.add(sql);
            }
        }
    }

    private boolean containsInActiveProfiles(Set<String> activeProfiles, String[] profile) {
        if (profile.length == 0) {
            return true;
        }
        for (String profileItem : profile) {
            if (!activeProfiles.contains(profileItem)) continue;
            return true;
        }
        return false;
    }

    private void limit() {
        Class<?> returnType = this.method.getReturnType();
        if (Collection.class.isAssignableFrom(returnType)) {
            MethodParam eqlPage = this.methodAllParam.getEqlPage();
            if (eqlPage != null) {
                this.mv.visitVarInsn(25, eqlPage.getParamIndex() + 1);
                this.mv.visitMethodInsn(182, EQL, "limit", Asms.sig(Eql.class, EqlPage.class), false);
            }
        } else {
            MethodParam eqlRowMapper = this.methodAllParam.getEqlRowMapper();
            EqlMapper eqlMapper = this.method.getAnnotation(EqlMapper.class);
            if (eqlRowMapper == null && eqlMapper == null) {
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(182, EQL, "limit", Asms.sig(Eql.class, Integer.TYPE), false);
            }
        }
    }

    private void returnType() {
        Class returnTypeClass = this.method.getReturnType();
        org.objectweb.asm.Type tp = org.objectweb.asm.Type.getType(returnTypeClass);
        MethodParam eqlRowMapper = this.methodAllParam.getEqlRowMapper();
        if (eqlRowMapper != null) {
            this.mv.visitVarInsn(25, eqlRowMapper.getVarIndex());
            this.mv.visitMethodInsn(182, EQL, "returnType", Asms.sig(Eql.class, EqlRowMapper.class), false);
            return;
        }
        EqlMapper eqlMapper = this.method.getAnnotation(EqlMapper.class);
        if (eqlMapper != null) {
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(eqlMapper.value());
            this.mv.visitLdcInsn((Object)returnType);
            this.mv.visitMethodInsn(182, EQL, "returnType", Asms.sig(Eql.class, Class.class), false);
            return;
        }
        MethodParam paramReturnType = this.methodAllParam.getParamReturnType();
        if (paramReturnType != null) {
            this.mv.visitVarInsn(25, paramReturnType.getVarIndex());
            this.mv.visitMethodInsn(182, EQL, "returnType", Asms.sig(Eql.class, Class.class), false);
            return;
        }
        if (tp.equals((Object)org.objectweb.asm.Type.VOID_TYPE)) {
            return;
        }
        if (tp.equals((Object)org.objectweb.asm.Type.BOOLEAN_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Boolean", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.BYTE_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Byte", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.CHAR_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Character", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.SHORT_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Short", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.INT_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Integer", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.LONG_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Long", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.FLOAT_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Float", "TYPE", "Ljava/lang/Class;");
        } else if (tp.equals((Object)org.objectweb.asm.Type.DOUBLE_TYPE)) {
            this.mv.visitFieldInsn(178, "java/lang/Double", "TYPE", "Ljava/lang/Class;");
        } else {
            boolean isCollectionGeneric;
            Type genericReturnType = this.method.getGenericReturnType();
            boolean bl = isCollectionGeneric = genericReturnType instanceof ParameterizedType && Collection.class.isAssignableFrom(returnTypeClass);
            if (isCollectionGeneric) {
                ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
                returnTypeClass = (Class)parameterizedType.getActualTypeArguments()[0];
            }
            org.objectweb.asm.Type returnType = org.objectweb.asm.Type.getType(returnTypeClass);
            this.mv.visitLdcInsn((Object)returnType);
        }
        this.mv.visitMethodInsn(182, EQL, "returnType", Asms.sig(Eql.class, Class.class), false);
    }

    private void id(String[] sqls) {
        if (sqls.length > 0) {
            this.mv.visitLdcInsn((Object)this.method.getName());
            this.mv.visitMethodInsn(182, EQL, "tagSqlId", Asms.sig(Eql.class, String.class), false);
        } else {
            SqlId sqlId = this.method.getAnnotation(SqlId.class);
            MethodParam paramEqlId = this.methodAllParam.getParamEqlId();
            if (paramEqlId == null) {
                this.mv.visitLdcInsn((Object)(sqlId == null ? this.method.getName() : sqlId.value()));
            } else {
                this.mv.visitVarInsn(25, paramEqlId.getParamIndex() + 1);
            }
            this.mv.visitMethodInsn(182, EQL, "id", Asms.sig(Eql.class, String.class), false);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void useSqlFile() {
        Sql sqlAnn = this.method.getAnnotation(Sql.class);
        if (sqlAnn != null) {
            return;
        }
        UseSqlFile useSqlFile = this.method.getAnnotation(UseSqlFile.class);
        if (useSqlFile == null) {
            useSqlFile = this.classUseSqlFile;
        }
        if (useSqlFile != null) {
            if (S.isNotBlank(useSqlFile.value())) {
                this.mv.visitLdcInsn((Object)useSqlFile.value());
                this.mv.visitMethodInsn(182, EQL, "useSqlFile", Asms.sig(Eql.class, String.class), false);
                return;
            } else {
                if (useSqlFile.clazz() == Void.class) throw new RuntimeException("Bad @UseSqlFile usage!");
                this.mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(useSqlFile.clazz()));
                this.mv.visitMethodInsn(182, EQL, "useSqlFile", Asms.sig(Eql.class, Class.class), false);
            }
            return;
        } else {
            this.mv.visitLdcInsn((Object)org.objectweb.asm.Type.getType(this.eqlerClass));
            this.mv.visitMethodInsn(182, EQL, "useSqlFile", Asms.sig(Eql.class, Class.class), false);
        }
    }

    private void params() {
        if (this.methodAllParam.getNamedParamsCount() > 0) {
            this.visitIntInsn(1);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.mv.visitInsn(89);
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(25, this.methodAllParam.getAsmLocalVarNamedParamIndex());
            this.mv.visitInsn(83);
            this.mv.visitMethodInsn(182, EQL, "params", Asms.sig(Eql.class, Object[].class), false);
            return;
        }
        if (this.methodAllParam.getSeqParamsCount() == 0) {
            return;
        }
        this.visitIntInsn(this.methodAllParam.getSeqParamsCount());
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int index = 0;
        for (int i = 0; i < this.methodAllParam.getParamsSize(); ++i) {
            MethodParam methodParam = this.methodAllParam.getMethodParam(i);
            if (methodParam.getSeqParamIndex() < 0) continue;
            this.mv.visitInsn(89);
            this.visitIntInsn(index++);
            this.visitVar(i + 1 + methodParam.getOffset(), org.objectweb.asm.Type.getType(methodParam.getParamType()));
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(182, EQL, "params", Asms.sig(Eql.class, Object[].class), false);
    }

    private void dynamics() {
        if (this.methodAllParam.getNamedDynamicCount() > 0) {
            this.visitIntInsn(1);
            this.mv.visitTypeInsn(189, "java/lang/Object");
            this.mv.visitInsn(89);
            this.mv.visitInsn(3);
            this.mv.visitVarInsn(25, this.methodAllParam.getAsmLocalVarNamedDynamicIndex());
            this.mv.visitInsn(83);
            this.mv.visitMethodInsn(182, EQL, "dynamics", Asms.sig(Eql.class, Object[].class), false);
            return;
        }
        if (this.methodAllParam.getSeqDynamicsCount() == 0) {
            return;
        }
        this.visitIntInsn(this.methodAllParam.getSeqDynamicsCount());
        this.mv.visitTypeInsn(189, "java/lang/Object");
        int index = 0;
        for (int i = 0; i < this.methodAllParam.getParamsSize(); ++i) {
            MethodParam methodParam = this.methodAllParam.getMethodParam(i);
            if (methodParam.getSeqDynamicIndex() < 0) continue;
            this.mv.visitInsn(89);
            this.visitIntInsn(index++);
            this.visitVar(i + 1 + methodParam.getOffset(), org.objectweb.asm.Type.getType(methodParam.getParamType()));
            this.mv.visitInsn(83);
        }
        this.mv.visitMethodInsn(182, EQL, "dynamics", Asms.sig(Eql.class, Object[].class), false);
    }

    private MethodAllParam parseParams(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        MethodAllParam methodAllParam = new MethodAllParam();
        for (int i = 0; i < parameterTypes.length; ++i) {
            MethodParam methodParam = new MethodParam();
            methodAllParam.addMethodParam(methodParam);
            methodParam.setParamIndex(i);
            methodParam.setParamType(parameterTypes[i]);
            methodParam.setParamAnnotations(paramAnnotations[i]);
        }
        methodAllParam.setMethodEqlId(method.getAnnotation(EqlId.class));
        methodAllParam.compute();
        return methodAllParam;
    }

    private void visitIntInsn(int i) {
        if (i <= 5) {
            this.mv.visitInsn(3 + i);
        } else {
            this.mv.visitIntInsn(16, i);
        }
    }
}

