/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler.generators;

import java.lang.reflect.Method;
import org.n3r.eql.Eql;
import org.n3r.eql.EqlTran;
import org.n3r.eql.eqler.annotations.EqlerConfig;
import org.n3r.eql.eqler.generators.Generatable;
import org.n3r.eql.trans.EqlTranThreadLocal;
import org.n3r.eql.util.Asms;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class TranableMethodGenerator<T>
implements Generatable {
    private final String methodName;
    private final String eqlClassName;
    private final EqlerConfig eqlerConfig;
    private final ClassWriter cw;

    public TranableMethodGenerator(ClassWriter classWriter, Method method, Class<T> eqlerClass) {
        this.methodName = method.getName();
        this.cw = classWriter;
        this.eqlerConfig = Generatable.parseEqlerConfig(eqlerClass);
        this.eqlClassName = this.eqlerConfig != null ? Type.getInternalName(this.eqlerConfig.eql()) : Asms.p(Eql.class);
    }

    @Override
    public void generate() {
        MethodVisitor mv = this.cw.visitMethod(1, this.methodName, "()V", null, null);
        mv.visitCode();
        if ("start".equals(this.methodName)) {
            this.start(mv);
        } else if ("commit".equals(this.methodName) || "rollback".equals(this.methodName)) {
            this.commitOrRollback(mv, this.methodName);
        } else if ("close".equals(this.methodName)) {
            this.close(mv);
        }
        mv.visitInsn(177);
        mv.visitMaxs(-1, -1);
        mv.visitEnd();
    }

    private void close(MethodVisitor mv) {
        mv.visitMethodInsn(184, Asms.p(EqlTranThreadLocal.class), "get", "()Lorg/n3r/eql/EqlTran;", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitMethodInsn(184, Asms.p(EqlTranThreadLocal.class), "clear", "()V", false);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Asms.p(EqlTran.class), "close", "()V", true);
        mv.visitLabel(l0);
        mv.visitFrame(1, 1, new Object[]{Asms.p(EqlTran.class)}, 0, null);
    }

    private void commitOrRollback(MethodVisitor mv, String methodName) {
        mv.visitMethodInsn(184, Asms.p(EqlTranThreadLocal.class), "get", "()Lorg/n3r/eql/EqlTran;", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Asms.p(EqlTran.class), methodName, "()V", true);
        mv.visitLabel(l0);
        mv.visitFrame(1, 1, new Object[]{Asms.p(EqlTran.class)}, 0, null);
    }

    private void newEql(MethodVisitor mv) {
        mv.visitTypeInsn(187, this.eqlClassName);
        mv.visitInsn(89);
        mv.visitLdcInsn((Object)(this.eqlerConfig != null ? this.eqlerConfig.value() : "DEFAULT"));
        mv.visitMethodInsn(183, this.eqlClassName, "<init>", "(Ljava/lang/String;)V", false);
        mv.visitMethodInsn(182, this.eqlClassName, "me", "()Lorg/n3r/eql/Eql;", false);
    }

    private void start(MethodVisitor mv) {
        mv.visitMethodInsn(184, Asms.p(EqlTranThreadLocal.class), "get", "()Lorg/n3r/eql/EqlTran;", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        Label l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitInsn(177);
        mv.visitLabel(l0);
        mv.visitFrame(1, 1, new Object[]{Asms.p(EqlTran.class)}, 0, null);
        this.newEql(mv);
        mv.visitMethodInsn(182, Asms.p(Eql.class), "newTran", "()Lorg/n3r/eql/EqlTran;", false);
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, Asms.p(EqlTranThreadLocal.class), "set", "(Lorg/n3r/eql/EqlTran;)V", false);
    }

    public static boolean isEqlTranableMethod(Method method) {
        if ("()V".equals(Type.getMethodDescriptor((Method)method))) {
            String name = method.getName();
            return "start".equals(name) || "commit".equals(name) || "rollback".equals(name) || "close".equals(name);
        }
        return false;
    }
}

