/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.eqler.spring;

import java.util.Arrays;
import java.util.Set;
import org.n3r.eql.eqler.annotations.Eqler;
import org.n3r.eql.eqler.annotations.EqlerConfig;
import org.n3r.eql.eqler.spring.EqlerScannerRegistrar;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathEqlerScanner
extends ClassPathBeanDefinitionScanner {
    public ClassPathEqlerScanner(BeanDefinitionRegistry registry) {
        super(registry, false);
    }

    public void registerFilters() {
        this.addExcludeFilter((metadataReader, metadataReaderFactory) -> !metadataReader.getClassMetadata().isInterface());
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Eqler.class));
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(EqlerConfig.class));
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No eqler was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        } else {
            for (BeanDefinitionHolder holder : beanDefinitions) {
                GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Creating EqlerFactoryBean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' eqlerInterface"));
                }
                definition.getPropertyValues().add("xyzInterface", (Object)definition.getBeanClassName());
                definition.setBeanClass(EqlerScannerRegistrar.EqlerFactoryBean.class);
            }
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) throws IllegalStateException {
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn((Object)("Skipping EqlerFactoryBean with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' eqlerInterface. Bean already defined with the same name!"));
        return false;
    }
}

