/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import org.n3r.eql.base.DynamicLanguageDriver;
import org.n3r.eql.parser.DynamicSql;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.LiteralPart;
import org.n3r.eql.parser.MultiPart;
import org.n3r.eql.parser.ParserUtils;
import org.n3r.eql.parser.PartParser;
import org.n3r.eql.parser.PartParserFactory;
import org.n3r.eql.parser.Sql;
import org.n3r.eql.parser.StaticSql;

public class DefaultDynamicLanguageDriver
implements DynamicLanguageDriver {
    @Override
    public Sql parse(EqlBlock block, List<String> oneSqlLines) {
        return this.parse(oneSqlLines);
    }

    public Sql parse(List<String> oneSqlLines) {
        List<String> stdLines = this.standardLines(oneSqlLines);
        MultiPart multiPart = new MultiPart();
        int ii = stdLines.size();
        for (int i = 0; i < ii; ++i) {
            String line = stdLines.get(i);
            if (line.startsWith("--")) {
                String clearLine = ParserUtils.substr(line, "--".length());
                PartParser partParser = PartParserFactory.tryParse(clearLine);
                if (partParser == null) continue;
                i = partParser.parse(stdLines, i + 1) - 1;
                multiPart.addPart(partParser.createPart());
                continue;
            }
            Matcher matcher = ParserUtils.inlineComment.matcher(line);
            if (!matcher.matches()) {
                multiPart.addPart(new LiteralPart(line));
                continue;
            }
            String cleanStr = matcher.group(1);
            PartParser partParser = PartParserFactory.tryParse(cleanStr);
            if (partParser != null) {
                i = partParser.parse(stdLines, i + 1) - 1;
                multiPart.addPart(partParser.createPart());
                continue;
            }
            multiPart.addPart(new LiteralPart(line));
        }
        if (multiPart.size() == 0) {
            return null;
        }
        if (multiPart.size() == 1 && multiPart.part(0) instanceof LiteralPart) {
            String sql = ((LiteralPart)multiPart.part(0)).getSql();
            if (ParserUtils.inlineComment.matcher(sql).matches()) {
                return null;
            }
            return new StaticSql(sql);
        }
        return new DynamicSql(multiPart);
    }

    private List<String> standardLines(List<String> oneSqlLines) {
        return this.rearrangeLinesForInlineComments(this.rearrangeLinesForLineCommentsAndOthers(oneSqlLines));
    }

    private List<String> rearrangeLinesForInlineComments(List<String> lines) {
        ArrayList convertedLines = Lists.newArrayList();
        StringBuilder mergedLine = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith("--")) {
                this.mergedAdd(convertedLines, mergedLine, line);
                continue;
            }
            Matcher matcher = ParserUtils.inlineComment.matcher(line);
            int lastStart = 0;
            while (matcher.find()) {
                int start = matcher.start();
                if (start > lastStart) {
                    this.mergeLine(mergedLine, line.substring(lastStart, start), false);
                }
                lastStart = matcher.end();
                this.mergedAdd(convertedLines, mergedLine, matcher.group());
            }
            if (lastStart < line.length()) {
                this.mergeLine(mergedLine, line.substring(lastStart), true);
                continue;
            }
            if (lastStart <= 0) continue;
            mergedLine.append('\n');
        }
        if (mergedLine.length() > 0) {
            convertedLines.add(mergedLine.toString());
        }
        return convertedLines;
    }

    private List<String> rearrangeLinesForLineCommentsAndOthers(List<String> oneSqlLines) {
        ArrayList convertedLines = Lists.newArrayList();
        StringBuilder mergedLine = new StringBuilder();
        for (String line : oneSqlLines) {
            if (line.startsWith("--")) {
                this.mergedAdd(convertedLines, mergedLine, line);
                continue;
            }
            this.mergeLine(mergedLine, line, true);
        }
        if (mergedLine.length() > 0) {
            convertedLines.add(mergedLine.toString());
        }
        return convertedLines;
    }

    private void mergedAdd(List<String> merged, StringBuilder mergedLine, String line) {
        if (mergedLine.length() > 0) {
            merged.add(mergedLine.toString());
            mergedLine.delete(0, mergedLine.length());
        }
        merged.add(line);
    }

    private void mergeLine(StringBuilder mergedLine, String line, boolean newLine) {
        String trim = line.trim();
        if (trim.length() == 0) {
            return;
        }
        String trim1 = this.mergeEndLfs(this.trimButLf(line));
        mergedLine.append(trim1);
        if (newLine && this.isLastCharNotLf(trim1)) {
            mergedLine.append('\n');
        }
    }

    private String mergeEndLfs(String line) {
        char c2;
        char c1;
        int to = line.length() - 1;
        while (to - 1 >= 0 && (c1 = line.charAt(to)) == (c2 = line.charAt(to - 1)) && c2 == '\n') {
            --to;
        }
        return line.substring(0, to + 1);
    }

    private boolean isLastCharNotLf(String str) {
        return str.charAt(str.length() - 1) != '\n';
    }

    private String trimButLf(String line) {
        char c;
        int to;
        char c2;
        int from;
        int length = line.length();
        for (from = 0; from < length && Character.isWhitespace(c2 = line.charAt(from)); ++from) {
        }
        for (to = length - 1; to >= 0 && Character.isWhitespace(c = line.charAt(to)) && c != '\n'; --to) {
        }
        return line.substring(from, to + 1);
    }
}

