/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.base.Optional;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.EqlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EqlResourceLoaderHelper {
    private static final Logger log = LoggerFactory.getLogger(EqlResourceLoaderHelper.class);

    public static LoadingCache<EqlUniqueSqlId, Optional<EqlBlock>> buildSqlCache(final Cache<String, Optional<Map<String, EqlBlock>>> fileCache) {
        return CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<EqlUniqueSqlId, Optional<EqlBlock>>(){

            public Optional<EqlBlock> load(EqlUniqueSqlId eqlUniqueSqlId) {
                return EqlResourceLoaderHelper.loadBlocks((Cache<String, Optional<Map<String, EqlBlock>>>)fileCache, eqlUniqueSqlId);
            }
        });
    }

    private static Optional<EqlBlock> loadBlocks(Cache<String, Optional<Map<String, EqlBlock>>> fileCache, EqlUniqueSqlId sqlId) {
        Optional blocks = (Optional)fileCache.getIfPresent((Object)sqlId.getSqlClassPath());
        EqlBlock eqlBlock = (EqlBlock)((Map)blocks.get()).get(sqlId.getSqlId());
        if (eqlBlock == null) {
            return Optional.absent();
        }
        eqlBlock.tryParseSqls();
        return Optional.of((Object)eqlBlock);
    }

    public static void updateBlockCache(String sqlContent, EqlResourceLoader eqlResourceLoader, String sqlClassPath, Cache<EqlUniqueSqlId, Optional<EqlBlock>> sqlCache, Cache<String, Optional<Map<String, EqlBlock>>> fileCache) {
        Optional oldBlocks = (Optional)fileCache.getIfPresent((Object)sqlClassPath);
        Set oldSqlIds = ((Map)oldBlocks.or(new HashMap())).keySet();
        EqlParser parser = new EqlParser(eqlResourceLoader, sqlClassPath);
        Map<String, EqlBlock> blocks = parser.parse(sqlContent);
        for (EqlBlock block : blocks.values()) {
            EqlUniqueSqlId uniqueSqlId = block.getUniqueSqlId();
            sqlCache.put((Object)uniqueSqlId, (Object)Optional.of((Object)block));
            oldSqlIds.remove(uniqueSqlId.getSqlId());
        }
        for (String uniqueId : oldSqlIds) {
            sqlCache.invalidate((Object)EqlUniqueSqlId.of(sqlClassPath, uniqueId));
        }
        fileCache.put((Object)sqlClassPath, (Object)Optional.of(blocks));
    }

    public static Map<String, EqlBlock> updateFileCache(String sqlContent, EqlResourceLoader eqlResourceLoader, String sqlClassPath, boolean eqlLazyLoad) {
        EqlParser parser = new EqlParser(eqlResourceLoader, sqlClassPath);
        return eqlLazyLoad ? parser.delayParse(sqlContent) : parser.parse(sqlContent);
    }

    private EqlResourceLoaderHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

