/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import org.n3r.eql.base.AfterPropertiesSet;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.map.EqlBeanRowMapper;
import org.n3r.eql.map.EqlCallableResultBeanMapper;
import org.n3r.eql.map.EqlCallableReturnMapMapper;
import org.n3r.eql.map.EqlCallableReturnMapper;
import org.n3r.eql.map.EqlMapMapper;
import org.n3r.eql.map.EqlMappingResult;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.map.EqlSingleValueMapper;
import org.n3r.eql.map.FromDbMapper;
import org.n3r.eql.map.MapperFactoryCache;
import org.n3r.eql.map.ResultSetRs;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.Enums;
import org.n3r.eql.util.O;
import org.n3r.eql.util.Rs;
import org.n3r.eql.util.S;

public class EqlRsRetriever {
    private EqlBlock eqlBlock;
    private static int DEFAULT_MAX_ROWS = 100000;
    private int maxRows = DEFAULT_MAX_ROWS;
    private EqlRowMapper eqlRowMapper;
    private String returnTypeName;
    private Class<?> returnType;

    public Object convert(ResultSet rs, EqlRun subSql) {
        return this.maxRows <= 1 || subSql.isWillReturnOnlyOneRow() ? this.firstRow(rs) : this.selectList(rs);
    }

    private Object firstRow(ResultSet rs) {
        boolean singleColumn;
        if (!rs.next()) {
            return null;
        }
        boolean bl = singleColumn = rs.getMetaData().getColumnCount() == 1;
        if (singleColumn) {
            Object resultSetValue = Rs.getResultSetValue(rs, 1);
            Object singleValue = this.convertSingleValue(resultSetValue, rs);
            return singleValue;
        }
        EqlRowMapper rowMapper = this.getRowMapper(rs.getMetaData());
        Object o = this.rowBeanCreate(rowMapper, false, rs, 1);
        return EqlRsRetriever.mapResult(o, rowMapper);
    }

    public Object selectRow(ResultSet rs, int rowIndex) {
        if (rowIndex > this.maxRows || !rs.next()) {
            return null;
        }
        EqlRowMapper rowMapper = this.getRowMapper(rs.getMetaData());
        boolean singleColumn = rs.getMetaData().getColumnCount() == 1;
        return this.rowBeanCreate(rowMapper, singleColumn, rs, rowIndex);
    }

    private Object selectList(ResultSet rs) {
        ArrayList<Object> result = new ArrayList<Object>();
        boolean singleColumn = rs.getMetaData().getColumnCount() == 1;
        EqlRowMapper rowMapper = this.getRowMapper(rs.getMetaData());
        for (int rowIndex = 1; rs.next() && rowIndex <= this.maxRows; ++rowIndex) {
            Object rowObject = this.rowBeanCreate(rowMapper, singleColumn, rs, rowIndex);
            if (rowObject == null) continue;
            result.add(rowObject);
        }
        return EqlRsRetriever.mapResult(result, rowMapper);
    }

    private static Object mapResult(Object result, EqlRowMapper rowMapper) {
        Method mappingResult = EqlRsRetriever.findEqlMappingResultMethod(rowMapper.getClass());
        return mappingResult == null ? result : O.invokeMethod(rowMapper, mappingResult).orElse(null);
    }

    private static Method findEqlMappingResultMethod(Class<? extends EqlRowMapper> rowMapperClass) {
        for (Method method : rowMapperClass.getMethods()) {
            if (!method.isAnnotationPresent(EqlMappingResult.class) || method.getParameterTypes().length != 0 || method.getReturnType() == Void.TYPE) continue;
            return method;
        }
        return null;
    }

    private Object rowBeanCreate(EqlRowMapper rowMapper, boolean isSingleColumn, ResultSet rs, int rowNum) {
        Object rowBean = rowMapper.mapRow(rs, rowNum, isSingleColumn);
        if (isSingleColumn) {
            rowBean = this.convertSingleValue(rowBean, rs);
        }
        if (rowBean instanceof AfterPropertiesSet) {
            ((AfterPropertiesSet)rowBean).afterPropertiesSet();
        }
        return rowBean;
    }

    private EqlRowMapper getRowMapper(ResultSetMetaData metaData) {
        if (this.eqlRowMapper != null) {
            return this.eqlRowMapper;
        }
        if (this.returnType == null && this.eqlBlock != null) {
            this.returnType = this.eqlBlock.getReturnType();
        }
        if (this.returnType != null && EqlRowMapper.class.isAssignableFrom(this.returnType)) {
            return (EqlRowMapper)Reflect.on(this.returnType).create().get();
        }
        if (this.returnType != null && !Map.class.isAssignableFrom(this.returnType)) {
            return new EqlBeanRowMapper(this.returnType);
        }
        return metaData.getColumnCount() > 1 ? new EqlMapMapper() : new EqlSingleValueMapper();
    }

    public EqlCallableReturnMapper getCallableReturnMapper() {
        if (this.returnType == null && this.eqlBlock != null) {
            this.returnType = this.eqlBlock.getReturnType();
        }
        if (this.returnType != null && EqlCallableReturnMapper.class.isAssignableFrom(this.returnType)) {
            return (EqlCallableReturnMapper)Reflect.on(this.returnType).create().get();
        }
        if (this.returnType != null && !Map.class.isAssignableFrom(this.returnType)) {
            return new EqlCallableResultBeanMapper(this.returnType);
        }
        return new EqlCallableReturnMapMapper();
    }

    private Object convertSingleValue(Object value, ResultSet rs) {
        String returnTypeName;
        if (value == null) {
            return null;
        }
        if (this.returnType == null && this.eqlBlock != null) {
            this.returnType = this.eqlBlock.getReturnType();
        }
        if ((returnTypeName = this.returnTypeName) == null) {
            String string = returnTypeName = this.eqlBlock == null ? null : this.eqlBlock.getReturnTypeName();
        }
        if (this.returnType == null && returnTypeName == null) {
            return value;
        }
        Object x = this.processString(value, returnTypeName);
        if (x != null) {
            return x;
        }
        x = this.processInt(value, returnTypeName);
        if (x != null) {
            return x;
        }
        x = this.processLong(value, returnTypeName);
        if (x != null) {
            return x;
        }
        x = this.processBoolean(value, returnTypeName);
        if (x != null) {
            return x;
        }
        x = this.processDouble(value, returnTypeName);
        if (x != null) {
            return x;
        }
        x = this.processFloat(value, returnTypeName);
        if (x != null) {
            return x;
        }
        x = this.processShort(value, returnTypeName);
        if (x != null) {
            return x;
        }
        if (this.returnType == null && returnTypeName != null) {
            this.returnType = Reflect.on(returnTypeName).type();
        }
        if (this.returnType != null && !this.returnType.isPrimitive()) {
            if (this.returnType.isEnum() && value instanceof String) {
                return Enums.valueOff(this.returnType, (String)value);
            }
            if (this.returnType == Timestamp.class) {
                return rs.getTimestamp(1);
            }
            Optional<FromDbMapper> mapper = MapperFactoryCache.getFromDbMapper(this.returnType);
            if (mapper.isPresent()) {
                return mapper.get().map(new ResultSetRs(rs), 1);
            }
            return new EqlBeanRowMapper(this.returnType).mapRow(rs, 1, false);
        }
        return value;
    }

    private Object processString(Object value, String returnTypeName) {
        if ("string".equalsIgnoreCase(returnTypeName) || this.returnType == String.class) {
            if (value instanceof byte[]) {
                return S.bytesToStr((byte[])value);
            }
            return String.valueOf(value);
        }
        return null;
    }

    private Object processInt(Object value, String returnTypeName) {
        if ("int".equalsIgnoreCase(returnTypeName) || this.returnType == Integer.class || this.returnType == Integer.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return Integer.parseInt(value.toString());
        }
        return null;
    }

    private Object processLong(Object value, String returnTypeName) {
        if ("long".equalsIgnoreCase(returnTypeName) || this.returnType == Long.class || this.returnType == Long.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return Long.parseLong(value.toString());
        }
        return null;
    }

    private Object processBoolean(Object value, String returnTypeName) {
        if ("boolean".equalsIgnoreCase(returnTypeName) || this.returnType == Boolean.class || this.returnType == Boolean.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue() == 1;
            }
            return Boolean.parseBoolean(value.toString());
        }
        return null;
    }

    private Object processDouble(Object value, String returnTypeName) {
        if ("double".equalsIgnoreCase(returnTypeName) || this.returnType == Double.class || this.returnType == Double.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return Double.parseDouble(value.toString());
        }
        return null;
    }

    private Object processFloat(Object value, String returnTypeName) {
        if ("float".equalsIgnoreCase(returnTypeName) || this.returnType == Float.class || this.returnType == Float.TYPE) {
            if (value instanceof Number) {
                return Float.valueOf(((Number)value).floatValue());
            }
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        return null;
    }

    private Object processShort(Object value, String returnTypeName) {
        if ("short".equalsIgnoreCase(returnTypeName) || this.returnType == Short.class || this.returnType == Short.TYPE) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return Short.parseShort(value.toString());
        }
        return null;
    }

    public void resetMaxRows() {
        this.maxRows = DEFAULT_MAX_ROWS;
    }

    public void setEqlBlock(EqlBlock eqlBlock) {
        this.eqlBlock = eqlBlock;
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    public void setEqlRowMapper(EqlRowMapper eqlRowMapper) {
        this.eqlRowMapper = eqlRowMapper;
    }

    public String getReturnTypeName() {
        return this.returnTypeName;
    }

    public void setReturnTypeName(String returnTypeName) {
        this.returnTypeName = returnTypeName;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class<?> returnType) {
        this.returnType = returnType;
    }
}

