/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.n3r.eql.base.EqlResourceLoader;
import org.n3r.eql.impl.AbstractEqlResourceLoader;
import org.n3r.eql.impl.EqlResourceLoaderHelper;
import org.n3r.eql.impl.EqlUniqueSqlId;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.C;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEqlResourceLoader
extends AbstractEqlResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(FileEqlResourceLoader.class);
    private static final Cache<String, Optional<Map<String, EqlBlock>>> fileCache = CacheBuilder.newBuilder().build();
    private static final LoadingCache<EqlUniqueSqlId, Optional<EqlBlock>> sqlCache = EqlResourceLoaderHelper.buildSqlCache(fileCache);

    @Override
    public EqlBlock loadEqlBlock(String classPath, String sqlId) {
        Map<String, EqlBlock> blocks = this.load(this, classPath);
        if (blocks == null) {
            throw new RuntimeException("unable to find sql file " + classPath);
        }
        EqlUniqueSqlId eqlUniqueSqlId = new EqlUniqueSqlId(classPath, sqlId);
        Optional eqlBlock = (Optional)sqlCache.getUnchecked((Object)eqlUniqueSqlId);
        if (eqlBlock.isPresent()) {
            return (EqlBlock)eqlBlock.get();
        }
        throw new RuntimeException("unable to find sql id " + eqlUniqueSqlId);
    }

    @Override
    public Map<String, EqlBlock> load(String classPath) {
        return this.load(this, classPath);
    }

    private Map<String, EqlBlock> load(EqlResourceLoader resLoader, String sqlClassPath) {
        Callable<Optional> valueLoader = () -> {
            String sqlContent = C.classResourceToString(sqlClassPath);
            if (sqlContent == null) {
                log.warn("classpath sql {} not found", (Object)sqlClassPath);
                return Optional.absent();
            }
            return Optional.of(EqlResourceLoaderHelper.updateFileCache(sqlContent, resLoader, sqlClassPath, this.eqlLazyLoad));
        };
        try {
            return (Map)((Optional)fileCache.get((Object)sqlClassPath, valueLoader)).orNull();
        }
        catch (ExecutionException e) {
            throw Throwables.getRootCause((Throwable)e);
        }
    }
}

