/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.base.Joiner;
import freemarker.cache.StringTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.util.List;
import org.n3r.eql.base.DynamicLanguageDriver;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.parser.FreemarkerSql;
import org.n3r.eql.parser.Sql;
import org.n3r.eql.parser.StaticSql;

public class FreemarkerDynamicLanguageDriver
implements DynamicLanguageDriver {
    @Override
    public Sql parse(EqlBlock block, List<String> oneSqlLines) {
        String template = Joiner.on((char)'\n').join(oneSqlLines);
        if (template.indexOf("<#") < 0) {
            return new StaticSql(template);
        }
        Configuration ftlConfig = new Configuration();
        StringTemplateLoader stringLoader = new StringTemplateLoader();
        ftlConfig.setTemplateLoader((TemplateLoader)stringLoader);
        String uniqueEqlIdStr = block.getUniqueSqlIdStr();
        stringLoader.putTemplate(uniqueEqlIdStr, template);
        Template temp = ftlConfig.getTemplate(uniqueEqlIdStr);
        return new FreemarkerSql(ftlConfig, temp);
    }
}

