/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.util.Og;

public class OgnlEvaluator
implements ExpressionEvaluator {
    @Override
    public Object eval(String expr, EqlRun eqlRun) {
        if (!eqlRun.isIterateOption()) {
            return Og.eval(expr, eqlRun.getMergedParamProperties(), eqlRun.getCachedProperties());
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Object iteratableOrArray = eqlRun.getIterateParams();
        if (iteratableOrArray == null) {
            return result;
        }
        if (iteratableOrArray instanceof Iterable) {
            for (Object element : (Iterable)iteratableOrArray) {
                Map<String, Object> params = eqlRun.getMergedParamPropertiesWith(element);
                HashMap cached = Maps.newHashMap();
                Object eval = Og.eval(expr, params, cached);
                result.add(eval);
            }
            return result;
        }
        if (iteratableOrArray.getClass().isArray()) {
            for (Object element : (Object[])iteratableOrArray) {
                Map<String, Object> params = eqlRun.getMergedParamPropertiesWith(element);
                HashMap cached = Maps.newHashMap();
                Object eval = Og.eval(expr, params, cached);
                result.add(eval);
            }
            return result;
        }
        return result;
    }

    @Override
    public Object evalDynamic(String expr, EqlRun eqlRun) {
        Map<String, Object> params = eqlRun.getMergedDynamicsProperties();
        return Og.eval(expr, params, eqlRun.getCachedProperties());
    }

    @Override
    public boolean evalBool(String expr, EqlRun eqlRun) {
        Object value = this.eval(expr, eqlRun);
        return value instanceof Boolean && (Boolean)value != false;
    }
}

