/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.n3r.eql.joor.Reflect;
import org.n3r.eql.map.EqlBaseBeanMapper;
import org.n3r.eql.map.EqlRowMapper;
import org.n3r.eql.map.ResultSetRs;
import org.n3r.eql.util.Rs;

public class EqlBeanRowMapper
extends EqlBaseBeanMapper
implements EqlRowMapper {
    public EqlBeanRowMapper(Class<?> mappedClass) {
        super(mappedClass);
    }

    @Override
    public Object mapRow(ResultSet rs, int rowNumber, boolean isSingleColumn) throws SQLException {
        if (isSingleColumn) {
            if (this.mappedClass == String.class) {
                return rs.getString(1);
            }
            if (this.mappedClass == Boolean.TYPE || this.mappedClass == Boolean.class) {
                return rs.getBoolean(1);
            }
            if (this.mappedClass == Short.TYPE || this.mappedClass == Short.class) {
                return rs.getShort(1);
            }
            if (this.mappedClass == Integer.TYPE || this.mappedClass == Integer.class) {
                return rs.getInt(1);
            }
            if (this.mappedClass == Long.TYPE || this.mappedClass == Long.class) {
                return rs.getLong(1);
            }
            if (this.mappedClass == Float.TYPE || this.mappedClass == Float.class) {
                return Float.valueOf(rs.getFloat(1));
            }
            if (this.mappedClass == Double.TYPE || this.mappedClass == Double.class) {
                return rs.getDouble(1);
            }
            if (this.mappedClass == BigDecimal.class) {
                return rs.getBigDecimal(1);
            }
            Object object = rs.getObject(1);
            if (object != null && this.mappedClass.isAssignableFrom(object.getClass())) {
                return object;
            }
        }
        Object mappedObject = Reflect.on(this.mappedClass).create().get();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        ResultSetRs rsAware = new ResultSetRs(rs);
        for (int index = 1; index <= columnCount; ++index) {
            String column = Rs.lookupColumnName(rsmd, index);
            boolean succ = this.setColumnValue(rsAware, mappedObject, index, column);
            if (succ || !isSingleColumn) continue;
            return rs.getObject(1);
        }
        return mappedObject;
    }
}

