/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.n3r.eql.config.EqlConfigDecorator;
import org.n3r.eql.map.EqlDynamic;
import org.n3r.eql.map.EqlType;
import org.n3r.eql.map.MapperFactoryCache;
import org.n3r.eql.map.ToDbMapper;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.InternalValueable;
import org.n3r.eql.param.PlaceholderType;
import org.n3r.eql.parser.EqlBlock;
import org.n3r.eql.util.BlackcatUtils;
import org.n3r.eql.util.Hex;
import org.n3r.eql.util.Logs;
import org.n3r.eql.util.P;
import org.n3r.eql.util.Pair;
import org.n3r.eql.util.S;
import org.slf4j.Logger;

public class EqlRun
implements Cloneable {
    public List<Pair<Integer, Object>> realParams = Lists.newArrayList();
    List<Object> boundParams;
    Connection connection;
    String evalSql;
    String evalSqlTemplate;
    EqlDynamic evalEqlDynamic;
    boolean iterateOption;
    String tagSqlId;
    boolean forEvaluate;
    Map<Object, Map<String, Object>> cachedProperties = Maps.newHashMap();
    private String traceParams;
    List<Pair<Integer, Integer>> outParameters = Lists.newArrayList();
    String runSql;
    String printSql;
    Object result;
    EqlConfigDecorator eqlConfig;
    EqlBlock eqlBlock;
    int placeholderNum;
    EqlParamPlaceholder[] placeHolders;
    PlaceholderType placeHolderType;
    PlaceholderType placeHolderOutType;
    EqlType sqlType;
    boolean lastSelectSql;
    boolean willReturnOnlyOneRow;
    Object[] extraBindParams;
    EqlDynamic eqlDynamic;
    int outCount;
    Map<String, Object> executionContext;
    Object[] params;
    Object[] dynamics;
    Object paramBean;
    static Pattern WHERE_PATTERN = Pattern.compile("\\bwhere\\b", 2);

    public void addRealParam(int index, Object value) {
        this.realParams.add(Pair.of(index, value));
    }

    public void registerOutParameter(int index, int type) {
        this.outParameters.add(Pair.of(index, type));
    }

    public void bindParamsForEvaluation(String sqlClassPath) {
        this.createEvalSql(-1, sqlClassPath, this.eqlConfig, this.tagSqlId, this.boundParams.toString());
    }

    public void setParam(PreparedStatement ps, int parameterIndex, Object parameterValue) {
        Object value = parameterValue;
        if (value != null) {
            Optional<ToDbMapper> mapper = MapperFactoryCache.getToDbMapper(value.getClass());
            if (mapper.isPresent()) {
                value = mapper.get().map(value);
            } else if (value.getClass().isEnum()) {
                value = value instanceof InternalValueable ? ((InternalValueable)value).internalValue() : "" + value;
            }
        }
        ps.setObject(parameterIndex, value);
    }

    public void bindParams(PreparedStatement ps, String sqlClassPath) {
        for (Pair<Integer, Object> pair : this.realParams) {
            this.setParam(ps, (Integer)pair._1, pair._2);
        }
        for (Pair<Integer, Object> pair : this.outParameters) {
            CallableStatement cs = (CallableStatement)ps;
            cs.registerOutParameter((int)((Integer)pair._1), (int)((Integer)pair._2));
        }
        this.createEvalSql(-1, sqlClassPath, this.eqlConfig, this.tagSqlId, this.boundParams.toString());
    }

    public void bindBatchParams(PreparedStatement ps, int index, String sqlClassPath) {
        for (Pair<Integer, Object> param : this.realParams) {
            Object x = ((Object[])param._2)[index];
            this.setParam(ps, (Integer)param._1, x);
        }
        this.createEvalSql(index, sqlClassPath, this.eqlConfig, this.tagSqlId, this.batchParamsString(this.boundParams, index));
    }

    private void createEvalSql(int index, String sqlClassPath, EqlConfigDecorator eqlConfig, String tagSqlId, String msg) {
        boolean hasBoundParams;
        boolean bl = hasBoundParams = this.boundParams != null && !this.boundParams.isEmpty();
        if (hasBoundParams) {
            Logger log = Logs.createLogger(eqlConfig, sqlClassPath, this.getSqlId(), tagSqlId, "params");
            log.debug(msg);
        }
        if (hasBoundParams) {
            Logger evalLog = Logs.createLogger(eqlConfig, sqlClassPath, this.getSqlId(), tagSqlId, "eval");
            this.evalSql = this.parseEvalSql(index);
            evalLog.debug(this.evalSql);
        } else {
            this.evalSql = this.evalSqlTemplate;
        }
        this.traceParams = msg;
    }

    private String batchParamsString(List<Object> boundParams, int index) {
        ArrayList bounds = Lists.newArrayList();
        for (Object object : boundParams) {
            bounds.add(((Object[])object)[index]);
        }
        return ((Object)bounds).toString();
    }

    private String parseEvalSql(int batchIndex) {
        String placeholder;
        int pos;
        StringBuilder eval = new StringBuilder();
        int startPos = 0;
        int index = -1;
        int size = this.boundParams.size();
        int evalSqlLength = this.evalSqlTemplate.length();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
        while (startPos < evalSqlLength && (pos = this.evalSqlTemplate.indexOf(placeholder = S.wrap(++index, '\u001a'), startPos)) >= 0) {
            eval.append(this.evalSqlTemplate, startPos, pos);
            if (index < size) {
                Object boundParam = this.boundParams.get(index);
                if (batchIndex >= 0) {
                    boundParam = ((Object[])boundParam)[batchIndex];
                }
                String evalBoundParam = this.createEvalBoundParam(simpleDateFormat, boundParam);
                eval.append(evalBoundParam);
            } else {
                eval.append('?');
            }
            startPos = pos + placeholder.length();
        }
        eval.append(this.evalSqlTemplate.substring(startPos));
        return eval.toString();
    }

    private String createEvalBoundParam(SimpleDateFormat simpleDateFormat, Object boundParam) {
        if (boundParam == null) {
            return "NULL";
        }
        if (boundParam instanceof Boolean) {
            return (Boolean)boundParam != false ? "1" : "0";
        }
        if (boundParam instanceof Number) {
            return boundParam.toString();
        }
        if (boundParam instanceof Date) {
            return S.wrap(simpleDateFormat.format((Date)boundParam), '\'');
        }
        if (boundParam instanceof byte[]) {
            return S.wrap(Hex.encode((byte[])boundParam), '\'');
        }
        return S.wrap(S.escapeSingleQuotes(boundParam.toString()), '\'');
    }

    public EqlRun clone() {
        return (EqlRun)super.clone();
    }

    private Object getDynamicsBean() {
        return this.dynamics == null || this.dynamics.length == 0 ? null : this.dynamics[0];
    }

    public void setRunSql(String runSql) {
        this.runSql = runSql;
        this.printSql = runSql.replaceAll("\\r?\\n", " ");
        this.checkNoWhereUpdate(runSql);
    }

    private void checkNoWhereUpdate(String runSql) {
        if (!this.sqlType.isUpdateDeleteStmt()) {
            return;
        }
        if (WHERE_PATTERN.matcher(runSql).find()) {
            return;
        }
        if (this.eqlBlock.getOptions().containsKey("NoWhere")) {
            return;
        }
        throw new RuntimeException("where clause is required when there is no NoWhere option with the sql " + runSql);
    }

    public String getSqlId() {
        if (S.isNotBlank(this.tagSqlId)) {
            return this.tagSqlId;
        }
        return this.eqlBlock != null ? this.eqlBlock.getSqlId() : "auto";
    }

    public void setPlaceHolders(EqlParamPlaceholder[] placeHolders) {
        this.placeHolders = placeHolders;
        this.outCount = 0;
        for (EqlParamPlaceholder placeHolder : placeHolders) {
            if (placeHolder.getInOut() == EqlParamPlaceholder.InOut.IN) continue;
            ++this.outCount;
        }
    }

    public EqlParamPlaceholder getPlaceHolder(int index) {
        return index < this.placeHolders.length ? this.placeHolders[index] : null;
    }

    public void setExtraBindParams(Object ... extraBindParams) {
        this.extraBindParams = extraBindParams;
    }

    public Map<String, Object> getMergedParamProperties() {
        return P.mergeProperties(this.executionContext, this.getParamBean());
    }

    public Map<String, Object> getMergedParamPropertiesWith(Object element) {
        return P.mergeProperties(this.executionContext, element);
    }

    public Object getIterateParams() {
        return ((Object[])((Map)this.getParamBean()).get("_params"))[0];
    }

    public Map<String, Object> getMergedDynamicsProperties() {
        return P.mergeProperties(this.executionContext, this.getDynamicsBean());
    }

    public void traceResult(Object execRet) {
        BlackcatUtils.trace(this.getSqlId(), this.printSql, this.traceParams, this.evalSql, execRet);
    }

    public void setBoundParams(List<Object> boundParams) {
        this.boundParams = boundParams;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public String getEvalSql() {
        return this.evalSql;
    }

    public String getEvalSqlTemplate() {
        return this.evalSqlTemplate;
    }

    public void setEvalSqlTemplate(String evalSqlTemplate) {
        this.evalSqlTemplate = evalSqlTemplate;
    }

    public void setEvalEqlDynamic(EqlDynamic evalEqlDynamic) {
        this.evalEqlDynamic = evalEqlDynamic;
    }

    public EqlDynamic getEvalEqlDynamic() {
        return this.evalEqlDynamic;
    }

    public void setIterateOption(boolean iterateOption) {
        this.iterateOption = iterateOption;
    }

    public boolean isIterateOption() {
        return this.iterateOption;
    }

    public void setTagSqlId(String tagSqlId) {
        this.tagSqlId = tagSqlId;
    }

    public String getTagSqlId() {
        return this.tagSqlId;
    }

    public void setForEvaluate(boolean forEvaluate) {
        this.forEvaluate = forEvaluate;
    }

    public boolean isForEvaluate() {
        return this.forEvaluate;
    }

    public Map<Object, Map<String, Object>> getCachedProperties() {
        return this.cachedProperties;
    }

    public String getRunSql() {
        return this.runSql;
    }

    public String getPrintSql() {
        return this.printSql;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public Object getResult() {
        return this.result;
    }

    public void setEqlConfig(EqlConfigDecorator eqlConfig) {
        this.eqlConfig = eqlConfig;
    }

    public EqlConfigDecorator getEqlConfig() {
        return this.eqlConfig;
    }

    public void setEqlBlock(EqlBlock eqlBlock) {
        this.eqlBlock = eqlBlock;
    }

    public EqlBlock getEqlBlock() {
        return this.eqlBlock;
    }

    public void setPlaceholderNum(int placeholderNum) {
        this.placeholderNum = placeholderNum;
    }

    public int getPlaceholderNum() {
        return this.placeholderNum;
    }

    public EqlParamPlaceholder[] getPlaceHolders() {
        return this.placeHolders;
    }

    public void setPlaceHolderType(PlaceholderType placeHolderType) {
        this.placeHolderType = placeHolderType;
    }

    public PlaceholderType getPlaceHolderType() {
        return this.placeHolderType;
    }

    public void setPlaceHolderOutType(PlaceholderType placeHolderOutType) {
        this.placeHolderOutType = placeHolderOutType;
    }

    public PlaceholderType getPlaceHolderOutType() {
        return this.placeHolderOutType;
    }

    public void setSqlType(EqlType sqlType) {
        this.sqlType = sqlType;
    }

    public EqlType getSqlType() {
        return this.sqlType;
    }

    public void setLastSelectSql(boolean lastSelectSql) {
        this.lastSelectSql = lastSelectSql;
    }

    public boolean isLastSelectSql() {
        return this.lastSelectSql;
    }

    public void setWillReturnOnlyOneRow(boolean willReturnOnlyOneRow) {
        this.willReturnOnlyOneRow = willReturnOnlyOneRow;
    }

    public boolean isWillReturnOnlyOneRow() {
        return this.willReturnOnlyOneRow;
    }

    public Object[] getExtraBindParams() {
        return this.extraBindParams;
    }

    public void setEqlDynamic(EqlDynamic eqlDynamic) {
        this.eqlDynamic = eqlDynamic;
    }

    public EqlDynamic getEqlDynamic() {
        return this.eqlDynamic;
    }

    public int getOutCount() {
        return this.outCount;
    }

    public void setExecutionContext(Map<String, Object> executionContext) {
        this.executionContext = executionContext;
    }

    public Map<String, Object> getExecutionContext() {
        return this.executionContext;
    }

    public void setParams(Object[] params) {
        this.params = params;
    }

    public Object[] getParams() {
        return this.params;
    }

    public void setDynamics(Object[] dynamics) {
        this.dynamics = dynamics;
    }

    public Object[] getDynamics() {
        return this.dynamics;
    }

    public void setParamBean(Object paramBean) {
        this.paramBean = paramBean;
    }

    public Object getParamBean() {
        return this.paramBean;
    }
}

