/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.map;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import org.n3r.eql.map.FromDbMapper;
import org.n3r.eql.map.MapperFactory;
import org.n3r.eql.map.ToDbMapper;

public class MapperFactoryCache {
    private static LoadingCache<Class<?>, Optional<FromDbMapper>> fromDbMappers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<FromDbMapper>>(){

        public Optional<FromDbMapper> load(Class<?> aClass) {
            for (FromDbMapper mapper : fromDbMapperSet) {
                if (!mapper.support(aClass)) continue;
                return Optional.of(mapper);
            }
            return Optional.empty();
        }
    });
    private static LoadingCache<Class<?>, Optional<ToDbMapper>> toDbMappers = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, Optional<ToDbMapper>>(){

        public Optional<ToDbMapper> load(Class<?> aClass) {
            for (ToDbMapper mapper : toDbMapperSet) {
                if (!mapper.support(aClass)) continue;
                return Optional.of(mapper);
            }
            return Optional.empty();
        }
    });
    private static Set<FromDbMapper> fromDbMapperSet = Sets.newHashSet();
    private static Set<ToDbMapper> toDbMapperSet = Sets.newHashSet();

    public static Optional<FromDbMapper> getFromDbMapper(Class<?> aClass) {
        return (Optional)fromDbMappers.getUnchecked(aClass);
    }

    public static Optional<ToDbMapper> getToDbMapper(Class<?> aClass) {
        return (Optional)toDbMappers.getUnchecked(aClass);
    }

    static {
        for (MapperFactory mapperFactory : ServiceLoader.load(MapperFactory.class)) {
            mapperFactory.addFromDbMapper(fromDbMapperSet);
            mapperFactory.addToDbMapper(toDbMapperSet);
        }
    }
}

