/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.mtcp;

import org.slf4j.MDC;

public class MtcpContext {
    public static final String TENANT_ID = "tenantId";
    public static final String TENANT_CODE = "tenantCode";
    private static ThreadLocal<String> tenantIdLocal = new InheritableThreadLocal<String>();
    private static ThreadLocal<String> tenantCodeLocal = new InheritableThreadLocal<String>();

    public static void setTenantId(String tenantId) {
        tenantIdLocal.set(tenantId);
        MDC.put((String)TENANT_ID, (String)tenantId);
    }

    public static void setTenantCode(String tenantCode) {
        tenantCodeLocal.set(tenantCode);
        MDC.put((String)TENANT_CODE, (String)tenantCode);
    }

    public static String getTenantId() {
        return tenantIdLocal.get();
    }

    public static String getTenantCode() {
        return tenantCodeLocal.get();
    }

    public static void clearTenant() {
        MtcpContext.clearTenantId();
        MtcpContext.clearTenantCode();
    }

    private static void clearTenantCode() {
        String tenantCode = MtcpContext.getTenantCode();
        if (tenantCode != null) {
            MDC.remove((String)TENANT_CODE);
        }
        tenantCodeLocal.remove();
    }

    private static void clearTenantId() {
        String tenantId = MtcpContext.getTenantId();
        if (tenantId != null) {
            MDC.remove((String)TENANT_ID);
        }
        tenantIdLocal.remove();
    }

    public static void clear() {
        MtcpContext.clearTenant();
    }
}

