/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.mtcp;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.codec.Charsets;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.mtcp.DataSourceConfigurator;
import org.n3r.eql.mtcp.MtcpContext;
import org.n3r.eql.mtcp.TenantPropertiesConfigurator;
import org.n3r.eql.mtcp.utils.Mtcps;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.S;
import org.slf4j.LoggerFactory;

public class MtcpDataSourceHandler
implements InvocationHandler {
    final TenantPropertiesConfigurator tenantPropertiesConfigurator;
    final EqlConfig eqlConfig;
    final ScheduledExecutorService scheduler;
    final MetricRegistry metricsRegistry;
    final LoadingCache<String, DataSourceConfigurator> mtcpCache;
    private static final String SHRINK_NOW_FILE_NAME = EqlUtils.expandUserHome("~/.eql/shrink.now");

    public MtcpDataSourceHandler(EqlConfig eqlConfig) {
        this.eqlConfig = eqlConfig;
        this.tenantPropertiesConfigurator = this.createMtcpTenantPropertiesConfigurator(eqlConfig);
        this.mtcpCache = this.createMtcpCache(eqlConfig);
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleWithFixedDelay(() -> this.mtcpCache.cleanUp(), 10L, 10L, TimeUnit.MINUTES);
        this.scheduler.scheduleWithFixedDelay(this::shrink, 10L, 10L, TimeUnit.SECONDS);
        this.metricsRegistry = new MetricRegistry();
        this.metricsRegistry.register(MetricRegistry.name((String)MtcpDataSourceHandler.class.getSimpleName(), (String[])new String[]{"cacheCount"}), (Metric)((Gauge)() -> this.mtcpCache.size()));
        Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricsRegistry).outputTo(LoggerFactory.getLogger(MtcpDataSourceHandler.class)).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build();
        reporter.start(1L, TimeUnit.MINUTES);
    }

    private void shrink() {
        File shrinkNowFile = new File(SHRINK_NOW_FILE_NAME);
        if (!shrinkNowFile.exists() || !shrinkNowFile.isFile()) {
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(".yyyyMMDDHHmmss.SSS");
        File dest = new File(SHRINK_NOW_FILE_NAME + simpleDateFormat.format(new Date()));
        shrinkNowFile.renameTo(dest);
        Collection configurators = this.mtcpCache.asMap().values();
        StringBuilder stat = new StringBuilder();
        int shrunk = 0;
        for (DataSourceConfigurator configurator : configurators) {
            ++shrunk;
            stat.append(configurator.shrink()).append(EqlUtils.LINE_SEPARATOR);
        }
        stat.append("Total " + shrunk + "/" + this.mtcpCache.size() + " were shrunk.").append(EqlUtils.LINE_SEPARATOR);
        Files.asCharSink((File)dest, (Charset)Charsets.UTF_8, (FileWriteMode[])new FileWriteMode[0]).write((CharSequence)stat);
    }

    private LoadingCache<String, DataSourceConfigurator> createMtcpCache(EqlConfig eqlConfig) {
        String key = "mtcpCacheSpec";
        String mtcpCacheSpec = eqlConfig.getStr("mtcpCacheSpec");
        Preconditions.checkNotNull((Object)mtcpCacheSpec, (String)"%s should not be empty!", (Object)"mtcpCacheSpec");
        return CacheBuilder.from((String)mtcpCacheSpec).removalListener(notification -> {
            String tenantId = (String)notification.getKey();
            DataSourceConfigurator dataSourceConfigurator = (DataSourceConfigurator)notification.getValue();
            dataSourceConfigurator.destroy(tenantId, this.metricsRegistry);
        }).build((CacheLoader)new CacheLoader<String, DataSourceConfigurator>(){

            public DataSourceConfigurator load(String tenantId) {
                return MtcpDataSourceHandler.this.createTenantDataSource(tenantId);
            }
        });
    }

    private TenantPropertiesConfigurator createMtcpTenantPropertiesConfigurator(EqlConfig eqlConfig) {
        String key = "tenantPropertiesConfigurator.spec";
        String impl = eqlConfig.getStr("tenantPropertiesConfigurator.spec");
        Preconditions.checkNotNull((Object)impl, (String)"%s should not be empty!", (Object)"tenantPropertiesConfigurator.spec");
        return Mtcps.createObjectBySpec(impl, TenantPropertiesConfigurator.class);
    }

    private DataSource getTenantDataSource() {
        String tenantId = MtcpContext.getTenantId();
        Preconditions.checkNotNull((Object)tenantId, (Object)"there is no tenant id set in current thread local");
        return ((DataSourceConfigurator)this.mtcpCache.getUnchecked((Object)tenantId)).getDataSource();
    }

    private DataSourceConfigurator createTenantDataSource(String tenantId) {
        String key = "dataSourceConfigurator.spec";
        String impl = this.eqlConfig.getStr("dataSourceConfigurator.spec");
        if (S.isBlank(impl)) {
            impl = "@org.n3r.eql.mtcp.impl.DruidDataSourceConfigurator";
        }
        DataSourceConfigurator dataSourceConfigurator = Mtcps.createObjectBySpec(impl, DataSourceConfigurator.class);
        Map<String, String> props = Mtcps.merge(this.eqlConfig.params(), this.tenantPropertiesConfigurator.getTenantProperties(tenantId));
        dataSourceConfigurator.prepare(tenantId, props, this.metricsRegistry, this.scheduler);
        return dataSourceConfigurator;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        return method.invoke((Object)this.getTenantDataSource(), args);
    }

    public DataSource newMtcpDataSource() {
        ClassLoader cl = this.getClass().getClassLoader();
        return (DataSource)Proxy.newProxyInstance(cl, new Class[]{DataSource.class}, (InvocationHandler)this);
    }
}

