/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.mtcp.impl;

import com.alibaba.druid.pool.DruidDataSource;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.n3r.eql.mtcp.DataSourceConfigurator;
import org.n3r.eql.util.O;
import org.n3r.eql.util.PropertyValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DruidDataSourceConfigurator
implements DataSourceConfigurator {
    private static final Logger log = LoggerFactory.getLogger(DruidDataSourceConfigurator.class);
    private static final AtomicInteger uniqueCodeGenerator = new AtomicInteger(0);
    private final int uniqueCode = uniqueCodeGenerator.incrementAndGet();
    private final DruidDataSource dataSource = new DruidDataSource();
    private String tenantId;

    @Override
    public void prepare(String tenantId, Map<String, String> props, MetricRegistry metricsRegistry, ScheduledExecutorService destroyScheduler) {
        this.tenantId = tenantId;
        this.createDruidDataSource(props, destroyScheduler);
        this.registerMetrics(tenantId + "-" + this.uniqueCode, metricsRegistry);
    }

    private void createDruidDataSource(Map<String, String> props, ScheduledExecutorService destroyScheduler) {
        O.populate(this.dataSource, props, new PropertyValueFilter[0]);
        this.dataSource.setDestroyScheduler(destroyScheduler);
    }

    @Override
    public DataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public void destroy(String tenantId, MetricRegistry metricsRegistry) {
        this.unregisterMetrics(tenantId + "-" + this.uniqueCode, metricsRegistry);
        this.destroyDatasource();
    }

    @Override
    public String shrink() {
        int poolingCount = this.dataSource.getPoolingCount();
        int activeCount = this.dataSource.getActiveCount();
        log.info("get to shrink with poolingCount:{}, activeCount:{} ", (Object)poolingCount, (Object)activeCount);
        this.dataSource.shrink();
        int endPoolingCount = this.dataSource.getPoolingCount();
        int endActiveCount = this.dataSource.getActiveCount();
        log.info("end to shrink with poolingCount:{}, activeCount:{} ", (Object)endPoolingCount, (Object)endActiveCount);
        return "tenantId:" + this.tenantId + ", poolingCount:" + poolingCount + "->" + endPoolingCount + ", activeCount:" + activeCount + "->" + endActiveCount + ".";
    }

    private void destroyDatasource() {
        try {
            this.dataSource.close();
        }
        catch (Exception e) {
            log.error("close dataSource error", (Throwable)e);
        }
    }

    public void registerMetrics(String tenantPrefixedId, MetricRegistry metricsRegistry) {
        String simpleName = DruidDataSource.class.getSimpleName();
        try {
            Gauge connectCount = () -> this.dataSource.getConnectCount();
            metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "connectCount"}), (Metric)connectCount);
            Gauge destroyCount = () -> this.dataSource.getDestroyCount();
            metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "destroyCount"}), (Metric)destroyCount);
            Gauge activeCount = () -> this.dataSource.getActiveCount();
            metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "activeCount"}), (Metric)activeCount);
            Gauge poolingCount = () -> this.dataSource.getPoolingCount();
            metricsRegistry.register(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "poolingCount"}), (Metric)poolingCount);
        }
        catch (Exception ex) {
            log.warn("register metrics err", (Throwable)ex);
        }
    }

    private void unregisterMetrics(String tenantPrefixedId, MetricRegistry metricsRegistry) {
        String simpleName = DruidDataSource.class.getSimpleName();
        try {
            metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "connectCount"}));
            metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "destroyCount"}));
            metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "activeCount"}));
            metricsRegistry.remove(MetricRegistry.name((String)simpleName, (String[])new String[]{tenantPrefixedId, "poolingCount"}));
        }
        catch (Exception ex) {
            log.warn("unregister metrics err", (Throwable)ex);
        }
    }
}

