/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.param;

import com.google.common.base.Splitter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.n3r.eql.param.EqlParamsParser;
import org.n3r.eql.param.PlaceholderType;
import org.n3r.eql.util.S;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlParamPlaceholder {
    private static final Logger log = LoggerFactory.getLogger(EqlParamPlaceholder.class);
    private int outType = 12;
    private boolean lob;
    private Like like = Like.None;
    private boolean numberColumn;
    private String placeholder;
    private InOut inOut = InOut.IN;
    private PlaceholderType placeholderType;
    private int seq;
    private boolean escape;
    private String escapeValue;
    private String defaultValue;
    private String contextName;
    private boolean contextOnly;

    public boolean hasDefaultValue() {
        return S.isNotEmpty(this.defaultValue);
    }

    public boolean hasContextOnly() {
        return this.contextName != null && this.contextOnly;
    }

    public boolean hasContextNormal() {
        return this.contextName != null && !this.contextOnly;
    }

    public void parseOption(EqlParamsParser.PlaceHolderTemp holder, String evalSqlTemplate) {
        Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
        Iterable optionParts = splitter.split((CharSequence)S.upperCase(holder.getPlaceHolderOptions()));
        for (String optionPart : optionParts) {
            String upperPureOption = this.parsePureOption(optionPart);
            String upperSubOption = this.parseSubOption(optionPart);
            if ("OUT".equals(upperPureOption)) {
                this.setInOut(InOut.OUT);
                this.parseOutType(upperSubOption);
                continue;
            }
            if ("INOUT".equals(upperPureOption)) {
                this.setInOut(InOut.INOUT);
                this.parseOutType(upperSubOption);
                continue;
            }
            if ("LOB".equals(upperPureOption)) {
                this.setLob(true);
                continue;
            }
            if ("LIKE".equals(upperPureOption)) {
                this.setLike(Like.Like);
                this.parseEscape(holder, evalSqlTemplate);
                continue;
            }
            if ("LEFTLIKE".equals(upperPureOption)) {
                this.setLike(Like.LeftLike);
                this.parseEscape(holder, evalSqlTemplate);
                continue;
            }
            if ("RIGHTLIKE".equals(upperPureOption)) {
                this.setLike(Like.RightLike);
                this.parseEscape(holder, evalSqlTemplate);
                continue;
            }
            if ("NUMBER".equals(upperPureOption)) {
                this.setNumberColumn(true);
                continue;
            }
            if ("CONTEXTONLY".equals(upperPureOption)) {
                this.setContextName(holder.placeHolder);
                this.setContextOnly(true);
                continue;
            }
            if ("CONTEXT".equals(upperPureOption)) {
                this.setContextName(holder.placeHolder);
                this.setContextOnly(false);
                continue;
            }
            if (upperPureOption.startsWith("!")) {
                this.setDefaultValue(S.trimToEmpty(upperPureOption.substring(1)));
                continue;
            }
            log.warn("unknown option {}", (Object)upperPureOption);
        }
    }

    private void parseEscape(EqlParamsParser.PlaceHolderTemp holder, String evalSqlTemplate) {
        String fromSub = S.wrap(holder.getQuestionSeq(), '\u001a');
        int fromSubIndex = evalSqlTemplate.indexOf(fromSub) + fromSub.length();
        Pattern escapePattern = Pattern.compile("\\s+ESCAPE\\s+(\\S+)", 34);
        String substring = evalSqlTemplate.substring(fromSubIndex);
        Matcher matcher = escapePattern.matcher(substring);
        this.setEscape(matcher.find());
        if (!this.isEscape()) {
            return;
        }
        String val = S.unQuote(matcher.group(1), "'");
        this.setEscapeValue(S.isNotEmpty(val) ? val.substring(0, 1) : "\\");
    }

    private void parseOutType(String subOptionUpper) {
        if (subOptionUpper == null) {
            return;
        }
        if ("LONG".equals(subOptionUpper)) {
            this.setOutType(-5);
        } else if ("INT".equals(subOptionUpper)) {
            this.setOutType(4);
        }
    }

    private String parseSubOption(String optionPart) {
        int leftBrace = optionPart.indexOf(40);
        if (leftBrace == -1) {
            return null;
        }
        int rightBrace = optionPart.indexOf(41, leftBrace);
        if (rightBrace == -1) {
            throw new RuntimeException("option " + optionPart + " hasn't right brace");
        }
        return S.trim(optionPart.substring(leftBrace + 1, rightBrace));
    }

    private String parsePureOption(String optionPart) {
        int leftBrace = optionPart.indexOf(40);
        if (leftBrace == -1) {
            return optionPart;
        }
        return S.trim(optionPart.substring(0, leftBrace));
    }

    public int getOutType() {
        return this.outType;
    }

    public boolean isLob() {
        return this.lob;
    }

    public Like getLike() {
        return this.like;
    }

    public boolean isNumberColumn() {
        return this.numberColumn;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public InOut getInOut() {
        return this.inOut;
    }

    public PlaceholderType getPlaceholderType() {
        return this.placeholderType;
    }

    public int getSeq() {
        return this.seq;
    }

    public boolean isEscape() {
        return this.escape;
    }

    public String getEscapeValue() {
        return this.escapeValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getContextName() {
        return this.contextName;
    }

    public boolean isContextOnly() {
        return this.contextOnly;
    }

    public void setOutType(int outType) {
        this.outType = outType;
    }

    public void setLob(boolean lob) {
        this.lob = lob;
    }

    public void setLike(Like like) {
        this.like = like;
    }

    public void setNumberColumn(boolean numberColumn) {
        this.numberColumn = numberColumn;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setInOut(InOut inOut) {
        this.inOut = inOut;
    }

    public void setPlaceholderType(PlaceholderType placeholderType) {
        this.placeholderType = placeholderType;
    }

    public void setSeq(int seq) {
        this.seq = seq;
    }

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setEscapeValue(String escapeValue) {
        this.escapeValue = escapeValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public void setContextOnly(boolean contextOnly) {
        this.contextOnly = contextOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EqlParamPlaceholder)) {
            return false;
        }
        EqlParamPlaceholder other = (EqlParamPlaceholder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOutType() != other.getOutType()) {
            return false;
        }
        if (this.isLob() != other.isLob()) {
            return false;
        }
        Like this$like = this.getLike();
        Like other$like = other.getLike();
        if (this$like == null ? other$like != null : !((Object)((Object)this$like)).equals((Object)other$like)) {
            return false;
        }
        if (this.isNumberColumn() != other.isNumberColumn()) {
            return false;
        }
        String this$placeholder = this.getPlaceholder();
        String other$placeholder = other.getPlaceholder();
        if (this$placeholder == null ? other$placeholder != null : !this$placeholder.equals(other$placeholder)) {
            return false;
        }
        InOut this$inOut = this.getInOut();
        InOut other$inOut = other.getInOut();
        if (this$inOut == null ? other$inOut != null : !((Object)((Object)this$inOut)).equals((Object)other$inOut)) {
            return false;
        }
        PlaceholderType this$placeholderType = this.getPlaceholderType();
        PlaceholderType other$placeholderType = other.getPlaceholderType();
        if (this$placeholderType == null ? other$placeholderType != null : !((Object)((Object)this$placeholderType)).equals((Object)other$placeholderType)) {
            return false;
        }
        if (this.getSeq() != other.getSeq()) {
            return false;
        }
        if (this.isEscape() != other.isEscape()) {
            return false;
        }
        String this$escapeValue = this.getEscapeValue();
        String other$escapeValue = other.getEscapeValue();
        if (this$escapeValue == null ? other$escapeValue != null : !this$escapeValue.equals(other$escapeValue)) {
            return false;
        }
        String this$defaultValue = this.getDefaultValue();
        String other$defaultValue = other.getDefaultValue();
        if (this$defaultValue == null ? other$defaultValue != null : !this$defaultValue.equals(other$defaultValue)) {
            return false;
        }
        String this$contextName = this.getContextName();
        String other$contextName = other.getContextName();
        if (this$contextName == null ? other$contextName != null : !this$contextName.equals(other$contextName)) {
            return false;
        }
        return this.isContextOnly() == other.isContextOnly();
    }

    protected boolean canEqual(Object other) {
        return other instanceof EqlParamPlaceholder;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getOutType();
        result = result * 59 + (this.isLob() ? 79 : 97);
        Like $like = this.getLike();
        result = result * 59 + ($like == null ? 43 : ((Object)((Object)$like)).hashCode());
        result = result * 59 + (this.isNumberColumn() ? 79 : 97);
        String $placeholder = this.getPlaceholder();
        result = result * 59 + ($placeholder == null ? 43 : $placeholder.hashCode());
        InOut $inOut = this.getInOut();
        result = result * 59 + ($inOut == null ? 43 : ((Object)((Object)$inOut)).hashCode());
        PlaceholderType $placeholderType = this.getPlaceholderType();
        result = result * 59 + ($placeholderType == null ? 43 : ((Object)((Object)$placeholderType)).hashCode());
        result = result * 59 + this.getSeq();
        result = result * 59 + (this.isEscape() ? 79 : 97);
        String $escapeValue = this.getEscapeValue();
        result = result * 59 + ($escapeValue == null ? 43 : $escapeValue.hashCode());
        String $defaultValue = this.getDefaultValue();
        result = result * 59 + ($defaultValue == null ? 43 : $defaultValue.hashCode());
        String $contextName = this.getContextName();
        result = result * 59 + ($contextName == null ? 43 : $contextName.hashCode());
        result = result * 59 + (this.isContextOnly() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "EqlParamPlaceholder(outType=" + this.getOutType() + ", lob=" + this.isLob() + ", like=" + (Object)((Object)this.getLike()) + ", numberColumn=" + this.isNumberColumn() + ", placeholder=" + this.getPlaceholder() + ", inOut=" + (Object)((Object)this.getInOut()) + ", placeholderType=" + (Object)((Object)this.getPlaceholderType()) + ", seq=" + this.getSeq() + ", escape=" + this.isEscape() + ", escapeValue=" + this.getEscapeValue() + ", defaultValue=" + this.getDefaultValue() + ", contextName=" + this.getContextName() + ", contextOnly=" + this.isContextOnly() + ")";
    }

    public static enum Like {
        None,
        Like,
        LeftLike,
        RightLike;

    }

    public static enum InOut {
        IN,
        OUT,
        INOUT;

    }
}

