/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.param;

import java.sql.Timestamp;
import java.util.Date;
import org.n3r.eql.param.EqlParamPlaceholder;
import org.n3r.eql.param.InternalValueable;
import org.n3r.eql.util.S;

public class ParamValueDealer {
    private EqlParamPlaceholder placeHolder;
    Object boundParam;
    Object paramValue;

    public ParamValueDealer(EqlParamPlaceholder placeHolder) {
        this.placeHolder = placeHolder;
    }

    public void dealSingleValue(Object value) {
        this.boundParam = value;
        this.paramValue = value;
        if (value == null) {
            if (this.placeHolder != null && this.placeHolder.hasDefaultValue()) {
                this.boundParam = this.placeHolder.getDefaultValue();
            }
            return;
        }
        if (value instanceof Date) {
            Timestamp date = new Timestamp(((Date)value).getTime());
            this.boundParam = S.toDateTimeStr(date);
            this.paramValue = date;
            return;
        }
        if (value.getClass().isEnum()) {
            this.boundParam = value instanceof InternalValueable ? (this.paramValue = ((InternalValueable)value).internalValue()) : "" + value;
            return;
        }
        if (this.placeHolder != null && value instanceof CharSequence) {
            String strValue = value.toString();
            if (this.placeHolder.isLob()) {
                this.paramValue = S.toBytes(strValue);
            } else if (this.placeHolder.getLike() == EqlParamPlaceholder.Like.Like) {
                this.paramValue = this.tryAddLeftAndRightPercent(strValue);
            } else if (this.placeHolder.getLike() == EqlParamPlaceholder.Like.RightLike) {
                this.paramValue = this.tryAddRightPercent(strValue);
            } else if (this.placeHolder.getLike() == EqlParamPlaceholder.Like.LeftLike) {
                this.paramValue = this.tryAddLeftPercent(strValue);
            } else if (this.placeHolder.isNumberColumn() && S.isBlank(strValue)) {
                this.paramValue = null;
            }
        }
        this.boundParam = this.paramValue;
    }

    private String tryAddLeftPercent(String strValue) {
        return this.addLeftPercent(strValue) + this.tryEscape(strValue);
    }

    private String tryAddRightPercent(String strValue) {
        return this.tryEscape(strValue) + this.addRightPercent(strValue);
    }

    private String tryAddLeftAndRightPercent(String strValue) {
        return this.addLeftPercent(strValue) + this.tryEscape(strValue) + this.addRightPercent(strValue);
    }

    private String addLeftPercent(String strValue) {
        return strValue.startsWith("%") ? (this.placeHolder.isEscape() ? "%" : "") : "%";
    }

    private String addRightPercent(String strValue) {
        return strValue.endsWith("%") ? (this.placeHolder.isEscape() ? "%" : "") : "%";
    }

    private String tryEscape(String strValue) {
        if (!this.placeHolder.isEscape()) {
            return strValue;
        }
        return strValue.replaceAll("[%_]", this.placeHolder.getEscapeValue() + "$0");
    }

    public Object getBoundParam() {
        return this.boundParam;
    }

    public Object getParamValue() {
        return this.paramValue;
    }
}

