/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.parser;

import java.util.List;
import org.n3r.eql.base.ExpressionEvaluator;
import org.n3r.eql.map.EqlRun;
import org.n3r.eql.parser.EqlPart;
import org.n3r.eql.parser.IfCondition;

public class IfPart
implements EqlPart {
    private final List<IfCondition> conditions;

    @Override
    public String evalSql(EqlRun eqlRun) {
        ExpressionEvaluator evaluator = eqlRun.getEqlConfig().getExpressionEvaluator();
        for (IfCondition ifc : this.conditions) {
            boolean ok = evaluator.evalBool(ifc.getExpr(), eqlRun);
            if (!ok) continue;
            return ifc.getValue().evalSql(eqlRun);
        }
        return "";
    }

    public IfPart(List<IfCondition> conditions) {
        this.conditions = conditions;
    }

    public List<IfCondition> getConditions() {
        return this.conditions;
    }
}

