/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.trans;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.pool.DruidPooledConnection;
import com.google.common.base.Objects;
import java.sql.Connection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.n3r.eql.config.EqlConfig;
import org.n3r.eql.mtcp.MtcpEnvironmentAware;
import org.n3r.eql.mtcp.utils.Mtcps;
import org.n3r.eql.trans.AbstractEqlConnection;
import org.n3r.eql.util.EqlUtils;
import org.n3r.eql.util.O;
import org.n3r.eql.util.PropertyValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EqlDruidConnection
extends AbstractEqlConnection {
    private static final Logger log = LoggerFactory.getLogger(EqlDruidConnection.class);
    DruidDataSource dataSource;
    MtcpEnvironmentAware mtcpEnvironmentAware;

    @Override
    public void initialize(EqlConfig eqlConfig) {
        Map<String, String> params = eqlConfig.params();
        EqlUtils.compatibleWithUserToUsername(params);
        this.dataSource = O.populate(new DruidDataSource(), params, new PropertyValueFilter[0]);
        this.dataSource.setInitVariants(true);
        this.mtcpEnvironmentAware = this.createMtcpEnvironmentAware(params);
    }

    private MtcpEnvironmentAware createMtcpEnvironmentAware(Map<String, String> params) {
        String implSepc = params.get("mtcpEnvironmentAwareClass.spec");
        if (StringUtils.isEmpty((CharSequence)implSepc)) {
            return null;
        }
        return Mtcps.createObjectBySpec(implSepc, MtcpEnvironmentAware.class);
    }

    @Override
    public Connection getConnection(String dbName) {
        DruidPooledConnection connection = this.dataSource.getConnection();
        this.attachMtcpEnvironment(connection);
        return connection;
    }

    private void attachMtcpEnvironment(DruidPooledConnection connection) {
        if (this.mtcpEnvironmentAware == null) {
            return;
        }
        String tenantId = this.mtcpEnvironmentAware.getTenantId();
        String name = this.mtcpEnvironmentAware.getClass().getName();
        Map variables = connection.getVariables();
        String lastTenantId = (String)variables.get(name);
        if (Objects.equal((Object)tenantId, (Object)lastTenantId)) {
            return;
        }
        variables.put(name, tenantId);
        String tenantDatabase = this.mtcpEnvironmentAware.getTenantDatabase();
        if (tenantDatabase == null) {
            return;
        }
        connection.setCatalog(tenantDatabase);
    }

    @Override
    public void destroy() {
        this.dataSource.close();
    }

    @Override
    public String getDriverName() {
        return this.dataSource.getDriverClassName();
    }

    @Override
    public String getJdbcUrl() {
        return this.dataSource.getUrl();
    }
}

