/*
 * Decompiled with CFR 0.152.
 */
package org.n3r.eql.util;

import com.github.bingoohuang.blackcat.instrument.callback.Blackcat;
import com.github.bingoohuang.blackcat.instrument.utils.Collections;
import com.github.bingoohuang.westjson.WestJson;
import java.util.Collection;

public final class BlackcatUtils {
    public static final boolean HAS_BLACKCAT = BlackcatUtils.classExists("com.github.bingoohuang.blackcat.instrument.callback.Blackcat");

    public static boolean classExists(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static void trace(String sqlId, String printSql, String traceParams, String evalSql, Object execRet) {
        if (!HAS_BLACKCAT) {
            return;
        }
        String paramsAndPrepared = "[]".equals(traceParams) ? "" : ", Params:" + traceParams + ", Prepared:" + printSql;
        Blackcat.trace((String)"SQL", (String)("ID:" + sqlId + ", SQL:" + evalSql + paramsAndPrepared + ", Result:" + BlackcatUtils.compressResult(execRet)), (Object[])new Object[0]);
    }

    private static Object compressResult(Object execRet) {
        if (!(execRet instanceof Collection)) {
            return new WestJson().json(execRet, 1);
        }
        return Collections.compressResult((Collection)((Collection)execRet));
    }

    private BlackcatUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

